/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.expression;

import io.smallrye.common.expression.Node;
import io.smallrye.common.expression.ResolveContext;
import io.smallrye.common.function.ExceptionBiConsumer;
import java.io.File;
import java.util.HashSet;

class LiteralNode
extends Node {
    static final LiteralNode DOLLAR = new LiteralNode("$");
    static final LiteralNode CLOSE_BRACE = new LiteralNode("}");
    static final LiteralNode FILE_SEP = new LiteralNode(File.separator);
    static final LiteralNode COLON = new LiteralNode(":");
    static final LiteralNode NEWLINE = new LiteralNode("\n");
    static final LiteralNode CARRIAGE_RETURN = new LiteralNode("\r");
    static final LiteralNode TAB = new LiteralNode("\t");
    static final LiteralNode BACKSPACE = new LiteralNode("\b");
    static final LiteralNode FORM_FEED = new LiteralNode("\f");
    static final LiteralNode BACKSLASH = new LiteralNode("\\");
    private final String literalValue;
    private final int start;
    private final int end;
    private String toString;

    LiteralNode(String literalValue, int start, int end) {
        this.literalValue = literalValue;
        this.start = start;
        this.end = end;
    }

    LiteralNode(String literalValue) {
        this(literalValue, 0, literalValue.length());
    }

    @Override
    <E extends Exception> void emit(ResolveContext<E> context, ExceptionBiConsumer<ResolveContext<E>, StringBuilder, E> resolveFunction) throws E {
        context.getStringBuilder().append(this.literalValue, this.start, this.end);
    }

    @Override
    void catalog(HashSet<String> strings) {
    }

    public String toString() {
        String toString = this.toString;
        return toString != null ? toString : (this.toString = this.literalValue.substring(this.start, this.end));
    }
}

