/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.core.management.impl.view.AddressField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;

public class AddressFilterPredicate
extends ActiveMQFilterPredicate<AddressControl> {
    private AddressField f;
    private final ActiveMQServer server;

    public AddressFilterPredicate(ActiveMQServer server) {
        this.server = server;
    }

    @Override
    public boolean test(AddressControl address) {
        if (this.f == null) {
            return true;
        }
        try {
            return switch (this.f) {
                default -> throw new IncompatibleClassChangeError();
                case AddressField.ID -> this.matches(address.getId());
                case AddressField.NAME -> this.matches(address.getAddress());
                case AddressField.ROUTING_TYPES -> this.matchAny(Arrays.asList(address.getRoutingTypes()));
                case AddressField.QUEUE_COUNT -> this.matches(address.getQueueCount());
                case AddressField.INTERNAL -> this.matches(address.isInternal());
                case AddressField.TEMPORARY -> this.matches(address.isTemporary());
                case AddressField.AUTO_CREATED -> this.matches(address.isAutoCreated());
                case AddressField.PAUSED -> this.matches(address.isPaused());
                case AddressField.CURRENT_DUPLICATE_ID_CACHE_SIZE -> this.matches(address.getCurrentDuplicateIdCacheSize());
                case AddressField.RETROACTIVE_RESOURCE -> this.matches(address.isRetroactiveResource());
                case AddressField.UNROUTED_MESSAGE_COUNT -> this.matches(address.getUnRoutedMessageCount());
                case AddressField.ROUTED_MESSAGE_COUNT -> this.matches(address.getRoutedMessageCount());
                case AddressField.MESSAGE_COUNT -> this.matches(address.getMessageCount());
                case AddressField.NUMBER_OF_BYTES_PER_PAGE -> this.matches(address.getNumberOfBytesPerPage());
                case AddressField.ADDRESS_LIMIT_PERCENT -> this.matches(address.getAddressLimitPercent());
                case AddressField.PAGING -> this.matches(address.isPaging());
                case AddressField.NUMBER_OF_PAGES -> this.matches(address.getNumberOfPages());
                case AddressField.ADDRESS_SIZE -> this.matches(address.getAddressSize());
                case AddressField.MAX_PAGE_READ_BYTES -> this.matches(address.getMaxPageReadBytes());
                case AddressField.MAX_PAGE_READ_MESSAGES -> this.matches(address.getMaxPageReadMessages());
                case AddressField.PREFETCH_PAGE_BYTES -> this.matches(address.getPrefetchPageBytes());
                case AddressField.PREFETCH_PAGE_MESSAGES -> this.matches(address.getPrefetchPageBytes());
            };
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.isEmpty()) {
            this.f = AddressField.valueOfName(field);
            if (this.f == null) {
                this.f = AddressField.valueOf(field);
            }
        }
    }
}

