/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.soap;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RM10Constants;
import org.apache.cxf.ws.rm.RM11Constants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.SequenceFault;

public class RMSoapOutInterceptor
extends AbstractSoapInterceptor {
    protected static JAXBContext jaxbContext;
    private static final Set<QName> HEADERS;
    private static final Logger LOG;

    public RMSoapOutInterceptor() {
        super("pre-protocol");
        this.addAfter(MAPCodec.class.getName());
    }

    public Set<QName> getUnderstoodHeaders() {
        return HEADERS;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        this.encode(message);
    }

    void encode(SoapMessage message) {
        Exception ex;
        RMProperties rmps = RMContextUtils.retrieveRMProperties((Message)message, true);
        if (null != rmps) {
            RMSoapOutInterceptor.encode(message, rmps);
        } else if (MessageUtils.isFault((Message)message) && (ex = (Exception)message.getContent(Exception.class)) instanceof SoapFault && ex.getCause() instanceof SequenceFault) {
            RMSoapOutInterceptor.encodeFault(message, (SequenceFault)ex.getCause());
        }
    }

    public static void encode(SoapMessage message, RMProperties rmps) {
        if (null == rmps) {
            return;
        }
        LOG.log(Level.FINE, "encoding RMPs in SOAP headers");
        try {
            AddressingProperties maps = RMContextUtils.retrieveMAPs((Message)message, false, true);
            ProtocolVariation protocol = ProtocolVariation.findVariant(rmps.getNamespaceURI(), maps.getNamespaceURI());
            List headers = message.getHeaders();
            int startSize = headers.size();
            protocol.getCodec().buildHeaders(rmps, headers);
            if (startSize != headers.size() && MessageUtils.isPartialResponse((Message)message)) {
                message.put(Message.RESPONSE_CODE, (Object)200);
            }
        }
        catch (JAXBException je) {
            LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", je);
        }
    }

    public static void encodeFault(SoapMessage message, SequenceFault sf) {
        LOG.log(Level.FINE, "Encoding SequenceFault in SOAP header");
        try {
            Message inmsg = message.getExchange().getInMessage();
            RMProperties rmps = RMContextUtils.retrieveRMProperties(inmsg, false);
            AddressingProperties maps = RMContextUtils.retrieveMAPs(inmsg, false, false);
            ProtocolVariation protocol = ProtocolVariation.findVariant(rmps.getNamespaceURI(), maps.getNamespaceURI());
            Header header = protocol.getCodec().buildHeaderFault(sf);
            List headers = message.getHeaders();
            headers.add(header);
        }
        catch (JAXBException je) {
            LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", je);
        }
    }

    static {
        HashSet<QName> set = new HashSet<QName>();
        set.addAll(RM10Constants.HEADERS);
        set.addAll(RM11Constants.HEADERS);
        HEADERS = set;
        LOG = LogUtils.getL7dLogger(RMSoapOutInterceptor.class);
    }
}

