/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.httpsignature.SignatureCreator;
import org.apache.cxf.rs.security.httpsignature.provider.KeyProvider;
import org.apache.cxf.rs.security.httpsignature.utils.SignatureHeaderUtils;
import org.tomitribe.auth.signatures.Join;
import org.tomitribe.auth.signatures.Signature;
import org.tomitribe.auth.signatures.Signer;

public class TomitribeSignatureCreator
implements SignatureCreator {
    private final String signatureAlgorithmName;
    private final KeyProvider keyProvider;
    private final String keyId;
    private final List<String> headersToSign;

    public TomitribeSignatureCreator(String signatureAlgorithmName, KeyProvider keyProvider, String keyId) {
        this(signatureAlgorithmName, keyProvider, keyId, Collections.emptyList());
    }

    public TomitribeSignatureCreator(String signatureAlgorithmName, KeyProvider keyProvider, String keyId, List<String> headersToSign) {
        this.signatureAlgorithmName = signatureAlgorithmName;
        this.keyProvider = keyProvider;
        this.keyId = keyId;
        this.headersToSign = headersToSign;
    }

    @Override
    public String createSignature(Map<String, List<String>> messageHeaders, String uri, String method) throws IOException {
        List headers;
        if (messageHeaders == null) {
            throw new IllegalArgumentException("message headers cannot be null");
        }
        if (this.headersToSign.isEmpty()) {
            headers = messageHeaders.keySet().stream().map(String::toLowerCase).collect(Collectors.toList());
            Message m = PhaseInterceptorChain.getCurrentMessage();
            if (MessageUtils.isRequestor((Message)m)) {
                headers.add("(request-target)");
            }
        } else {
            headers = this.headersToSign.stream().map(String::toLowerCase).collect(Collectors.toList());
        }
        if (this.keyId == null) {
            throw new IllegalArgumentException("key id cannot be null");
        }
        Signature signature = new Signature(this.keyId, this.signatureAlgorithmName, null, headers);
        Signer signer = new Signer(this.keyProvider.getKey(this.keyId), signature);
        Signature outputSignature = signer.sign(method, uri, SignatureHeaderUtils.mapHeaders(messageHeaders));
        StringBuilder sb = new StringBuilder(128);
        sb.append("keyId=\"");
        sb.append(outputSignature.getKeyId());
        sb.append('\"');
        sb.append(",algorithm=\"");
        sb.append(outputSignature.getAlgorithm());
        sb.append('\"');
        sb.append(",headers=\"");
        sb.append(Join.join((String)" ", (Collection)outputSignature.getHeaders()));
        sb.append('\"');
        sb.append(",signature=\"");
        sb.append(outputSignature.getSignature());
        sb.append('\"');
        return sb.toString();
    }
}

