/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.servlet.sci;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.servlet.CXFNonSpringJaxrsServlet;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

@HandlesTypes(value={Application.class, Provider.class, Path.class})
public class JaxrsServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOG = LogUtils.getL7dLogger(JaxrsServletContainerInitializer.class);
    private static final String IGNORE_PACKAGE = "org.apache.cxf";
    private static final String JAXRS_APPLICATION_SERVLET_NAME = "jakarta.ws.rs.core.Application";
    private static final String JAXRS_APPLICATION_PARAM = "jakarta.ws.rs.Application";
    private static final String CXF_JAXRS_APPLICATION_PARAM = "jaxrs.application";
    private static final String CXF_JAXRS_CLASSES_PARAM = "jaxrs.classes";

    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        Application app = null;
        String servletName = null;
        Object servletMapping = null;
        Class<?> appClass = JaxrsServletContainerInitializer.findCandidate(classes);
        if (appClass != null) {
            if (this.isApplicationServletAvailable(ctx, appClass)) {
                return;
            }
            try {
                app = (Application)appClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                throw new ServletException(t);
            }
            servletName = appClass.getName();
            ApplicationPath appPath = ResourceUtils.locateApplicationPath(appClass);
            servletMapping = appPath != null ? appPath.value() + "/*" : this.getServletMapping(ctx, servletName);
        }
        if (app == null || app.getClasses().isEmpty() && app.getSingletons().isEmpty()) {
            if (this.isCxfServletAvailable(ctx)) {
                return;
            }
            final Map<Class<Annotation>, Collection<Class<?>>> providersAndResources = this.groupByAnnotations(classes);
            if (!providersAndResources.get(Path.class).isEmpty() || !providersAndResources.get(Provider.class).isEmpty()) {
                if (app == null) {
                    servletName = JAXRS_APPLICATION_SERVLET_NAME;
                    servletMapping = this.getServletMapping(ctx, servletName);
                }
                final Map appProperties = app != null ? app.getProperties() : Collections.emptyMap();
                app = new Application(){

                    public Set<Class<?>> getClasses() {
                        HashSet set = new HashSet();
                        set.addAll((Collection)providersAndResources.get(Path.class));
                        set.addAll((Collection)providersAndResources.get(Provider.class));
                        return set;
                    }

                    public Map<String, Object> getProperties() {
                        return appProperties;
                    }
                };
            }
        }
        if (app == null) {
            return;
        }
        CXFNonSpringJaxrsServlet cxfServlet = new CXFNonSpringJaxrsServlet(app);
        ServletRegistration.Dynamic servlet = ctx.addServlet(servletName, (Servlet)cxfServlet);
        servlet.addMapping(new String[]{servletMapping});
    }

    private boolean isCxfServletAvailable(ServletContext ctx) {
        for (Map.Entry entry : ctx.getServletRegistrations().entrySet()) {
            if (((ServletRegistration)entry.getValue()).getInitParameter(CXF_JAXRS_CLASSES_PARAM) == null) continue;
            return true;
        }
        return false;
    }

    private String getServletMapping(ServletContext ctx, String name) throws ServletException {
        ServletRegistration sr = ctx.getServletRegistration(name);
        if (sr != null) {
            return (String)sr.getMappings().iterator().next();
        }
        String error = "Servlet with a name " + name + " is not available";
        throw new ServletException(error);
    }

    private boolean isApplicationServletAvailable(ServletContext ctx, Class<?> appClass) {
        for (Map.Entry entry : ctx.getServletRegistrations().entrySet()) {
            String appParam = ((ServletRegistration)entry.getValue()).getInitParameter(JAXRS_APPLICATION_PARAM);
            if (appParam == null) {
                appParam = ((ServletRegistration)entry.getValue()).getInitParameter(CXF_JAXRS_APPLICATION_PARAM);
            }
            if (appParam == null || !appParam.equals(appClass.getName())) continue;
            return true;
        }
        return false;
    }

    private Map<Class<? extends Annotation>, Collection<Class<?>>> groupByAnnotations(Set<Class<?>> classes) {
        HashMap grouped = new HashMap();
        grouped.put(Provider.class, new ArrayList());
        grouped.put(Path.class, new ArrayList());
        if (classes != null) {
            for (Class<?> clazz : classes) {
                if (JaxrsServletContainerInitializer.classShouldBeIgnored(clazz)) continue;
                for (Map.Entry entry : grouped.entrySet()) {
                    if (!clazz.isAnnotationPresent((Class)entry.getKey())) continue;
                    ((Collection)entry.getValue()).add(clazz);
                }
            }
        }
        return grouped;
    }

    private static boolean classShouldBeIgnored(Class<?> clazz) {
        return clazz.getPackage().getName().startsWith(IGNORE_PACKAGE);
    }

    private static Class<?> findCandidate(Set<Class<?>> classes) {
        if (classes != null) {
            for (Class<?> clazz : classes) {
                if (!Application.class.isAssignableFrom(clazz) || JaxrsServletContainerInitializer.classShouldBeIgnored(clazz)) continue;
                LOG.fine("Found JAX-RS application to initialize: " + clazz.getName());
                return clazz;
            }
        }
        return null;
    }
}

