/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.NoOpLog;

public class ConfigurationLogger {
    private final Log log;

    private static Log createLoggerForClass(Class<?> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Logger class must not be null!");
        }
        return LogFactory.getLog(cls);
    }

    private static Log createLoggerForName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Logger name must not be null!");
        }
        return LogFactory.getLog((String)name);
    }

    public static ConfigurationLogger newDummyLogger() {
        return new ConfigurationLogger((Log)new NoOpLog());
    }

    protected ConfigurationLogger() {
        this((Log)null);
    }

    public ConfigurationLogger(Class<?> logCls) {
        this(ConfigurationLogger.createLoggerForClass(logCls));
    }

    ConfigurationLogger(Log wrapped) {
        this.log = wrapped;
    }

    public ConfigurationLogger(String loggerName) {
        this(ConfigurationLogger.createLoggerForName(loggerName));
    }

    public void debug(String msg) {
        this.getLog().debug((Object)msg);
    }

    public void error(String msg) {
        this.getLog().error((Object)msg);
    }

    public void error(String msg, Throwable ex) {
        this.getLog().error((Object)msg, ex);
    }

    Log getLog() {
        return this.log;
    }

    public void info(String msg) {
        this.getLog().info((Object)msg);
    }

    public boolean isDebugEnabled() {
        return this.getLog().isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.getLog().isInfoEnabled();
    }

    public void warn(String msg) {
        this.getLog().warn((Object)msg);
    }

    public void warn(String msg, Throwable ex) {
        this.getLog().warn((Object)msg, ex);
    }
}

