/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import org.apache.daffodil.io.DataOutputStream;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.lib.util.MaybeInt$;
import org.apache.daffodil.lib.util.Numbers$;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.parsers.BinaryNumberCheckWidth;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.unparsers.runtime1.BinaryNumberBaseUnparser;
import scala.Predef$;

public abstract class BinaryIntegerBaseUnparser
extends BinaryNumberBaseUnparser
implements BinaryNumberCheckWidth {
    private final NodeInfo.PrimType.PrimNumeric primNumeric;

    public BinaryIntegerBaseUnparser(ElementRuntimeData e) {
        super(e);
        this.primNumeric = (NodeInfo.PrimType.PrimNumeric)e.optPrimType().get();
    }

    @Override
    public boolean putNumber(DataOutputStream dos, Number value, int nBits, FormatInfo finfo) {
        UState state = (UState)finfo;
        if (MaybeInt$.MODULE$.isDefined$extension(this.primNumeric.minWidth())) {
            int minWidth = MaybeInt$.MODULE$.get$extension(this.primNumeric.minWidth());
            boolean isSigned = this.primNumeric.isSigned();
            this.checkMinWidth(state, isSigned, nBits, minWidth);
        }
        if (MaybeInt$.MODULE$.isDefined$extension(this.primNumeric.maxWidth())) {
            int maxWidth = MaybeInt$.MODULE$.get$extension(this.primNumeric.maxWidth());
            this.checkMaxWidth(state, nBits, maxWidth);
        }
        if (nBits > 64) {
            return dos.putBigInt(Numbers$.MODULE$.asBigInt(value), nBits, this.primNumeric.isSigned(), finfo);
        }
        return dos.putLong(Predef$.MODULE$.Long2long(Numbers$.MODULE$.asLong(value)), nBits, finfo);
    }
}

