/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AutoPlacement;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.HostMaintenance;
import com.amazonaws.services.ec2.model.HostRecovery;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.AllocateHostsRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AllocateHostsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<AllocateHostsRequest> {
    private String autoPlacement;
    private String availabilityZone;
    private String clientToken;
    private String instanceType;
    private String instanceFamily;
    private Integer quantity;
    private SdkInternalList<TagSpecification> tagSpecifications;
    private String hostRecovery;
    private String outpostArn;
    private String hostMaintenance;
    private SdkInternalList<String> assetIds;

    public void setAutoPlacement(String autoPlacement) {
        this.autoPlacement = autoPlacement;
    }

    public String getAutoPlacement() {
        return this.autoPlacement;
    }

    public AllocateHostsRequest withAutoPlacement(String autoPlacement) {
        this.setAutoPlacement(autoPlacement);
        return this;
    }

    public void setAutoPlacement(AutoPlacement autoPlacement) {
        this.withAutoPlacement(autoPlacement);
    }

    public AllocateHostsRequest withAutoPlacement(AutoPlacement autoPlacement) {
        this.autoPlacement = autoPlacement.toString();
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public AllocateHostsRequest withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public AllocateHostsRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public AllocateHostsRequest withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setInstanceFamily(String instanceFamily) {
        this.instanceFamily = instanceFamily;
    }

    public String getInstanceFamily() {
        return this.instanceFamily;
    }

    public AllocateHostsRequest withInstanceFamily(String instanceFamily) {
        this.setInstanceFamily(instanceFamily);
        return this;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public AllocateHostsRequest withQuantity(Integer quantity) {
        this.setQuantity(quantity);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public AllocateHostsRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public AllocateHostsRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public void setHostRecovery(String hostRecovery) {
        this.hostRecovery = hostRecovery;
    }

    public String getHostRecovery() {
        return this.hostRecovery;
    }

    public AllocateHostsRequest withHostRecovery(String hostRecovery) {
        this.setHostRecovery(hostRecovery);
        return this;
    }

    public void setHostRecovery(HostRecovery hostRecovery) {
        this.withHostRecovery(hostRecovery);
    }

    public AllocateHostsRequest withHostRecovery(HostRecovery hostRecovery) {
        this.hostRecovery = hostRecovery.toString();
        return this;
    }

    public void setOutpostArn(String outpostArn) {
        this.outpostArn = outpostArn;
    }

    public String getOutpostArn() {
        return this.outpostArn;
    }

    public AllocateHostsRequest withOutpostArn(String outpostArn) {
        this.setOutpostArn(outpostArn);
        return this;
    }

    public void setHostMaintenance(String hostMaintenance) {
        this.hostMaintenance = hostMaintenance;
    }

    public String getHostMaintenance() {
        return this.hostMaintenance;
    }

    public AllocateHostsRequest withHostMaintenance(String hostMaintenance) {
        this.setHostMaintenance(hostMaintenance);
        return this;
    }

    public void setHostMaintenance(HostMaintenance hostMaintenance) {
        this.withHostMaintenance(hostMaintenance);
    }

    public AllocateHostsRequest withHostMaintenance(HostMaintenance hostMaintenance) {
        this.hostMaintenance = hostMaintenance.toString();
        return this;
    }

    public List<String> getAssetIds() {
        if (this.assetIds == null) {
            this.assetIds = new SdkInternalList();
        }
        return this.assetIds;
    }

    public void setAssetIds(Collection<String> assetIds) {
        if (assetIds == null) {
            this.assetIds = null;
            return;
        }
        this.assetIds = new SdkInternalList(assetIds);
    }

    public AllocateHostsRequest withAssetIds(String ... assetIds) {
        if (this.assetIds == null) {
            this.setAssetIds((Collection<String>)new SdkInternalList(assetIds.length));
        }
        for (String ele : assetIds) {
            this.assetIds.add((Object)ele);
        }
        return this;
    }

    public AllocateHostsRequest withAssetIds(Collection<String> assetIds) {
        this.setAssetIds(assetIds);
        return this;
    }

    @Override
    public Request<AllocateHostsRequest> getDryRunRequest() {
        Request<AllocateHostsRequest> request = new AllocateHostsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoPlacement() != null) {
            sb.append("AutoPlacement: ").append(this.getAutoPlacement()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getInstanceFamily() != null) {
            sb.append("InstanceFamily: ").append(this.getInstanceFamily()).append(",");
        }
        if (this.getQuantity() != null) {
            sb.append("Quantity: ").append(this.getQuantity()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getHostRecovery() != null) {
            sb.append("HostRecovery: ").append(this.getHostRecovery()).append(",");
        }
        if (this.getOutpostArn() != null) {
            sb.append("OutpostArn: ").append(this.getOutpostArn()).append(",");
        }
        if (this.getHostMaintenance() != null) {
            sb.append("HostMaintenance: ").append(this.getHostMaintenance()).append(",");
        }
        if (this.getAssetIds() != null) {
            sb.append("AssetIds: ").append(this.getAssetIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateHostsRequest)) {
            return false;
        }
        AllocateHostsRequest other = (AllocateHostsRequest)obj;
        if (other.getAutoPlacement() == null ^ this.getAutoPlacement() == null) {
            return false;
        }
        if (other.getAutoPlacement() != null && !other.getAutoPlacement().equals(this.getAutoPlacement())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getInstanceFamily() == null ^ this.getInstanceFamily() == null) {
            return false;
        }
        if (other.getInstanceFamily() != null && !other.getInstanceFamily().equals(this.getInstanceFamily())) {
            return false;
        }
        if (other.getQuantity() == null ^ this.getQuantity() == null) {
            return false;
        }
        if (other.getQuantity() != null && !other.getQuantity().equals(this.getQuantity())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getHostRecovery() == null ^ this.getHostRecovery() == null) {
            return false;
        }
        if (other.getHostRecovery() != null && !other.getHostRecovery().equals(this.getHostRecovery())) {
            return false;
        }
        if (other.getOutpostArn() == null ^ this.getOutpostArn() == null) {
            return false;
        }
        if (other.getOutpostArn() != null && !other.getOutpostArn().equals(this.getOutpostArn())) {
            return false;
        }
        if (other.getHostMaintenance() == null ^ this.getHostMaintenance() == null) {
            return false;
        }
        if (other.getHostMaintenance() != null && !other.getHostMaintenance().equals(this.getHostMaintenance())) {
            return false;
        }
        if (other.getAssetIds() == null ^ this.getAssetIds() == null) {
            return false;
        }
        return other.getAssetIds() == null || other.getAssetIds().equals(this.getAssetIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoPlacement() == null ? 0 : this.getAutoPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceFamily() == null ? 0 : this.getInstanceFamily().hashCode());
        hashCode = 31 * hashCode + (this.getQuantity() == null ? 0 : this.getQuantity().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getHostRecovery() == null ? 0 : this.getHostRecovery().hashCode());
        hashCode = 31 * hashCode + (this.getOutpostArn() == null ? 0 : this.getOutpostArn().hashCode());
        hashCode = 31 * hashCode + (this.getHostMaintenance() == null ? 0 : this.getHostMaintenance().hashCode());
        hashCode = 31 * hashCode + (this.getAssetIds() == null ? 0 : this.getAssetIds().hashCode());
        return hashCode;
    }

    public AllocateHostsRequest clone() {
        return (AllocateHostsRequest)super.clone();
    }
}

