/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateIpamExternalResourceVerificationTokenRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateIpamExternalResourceVerificationTokenRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateIpamExternalResourceVerificationTokenRequest> {
    private String ipamId;
    private SdkInternalList<TagSpecification> tagSpecifications;
    private String clientToken;

    public void setIpamId(String ipamId) {
        this.ipamId = ipamId;
    }

    public String getIpamId() {
        return this.ipamId;
    }

    public CreateIpamExternalResourceVerificationTokenRequest withIpamId(String ipamId) {
        this.setIpamId(ipamId);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public CreateIpamExternalResourceVerificationTokenRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public CreateIpamExternalResourceVerificationTokenRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateIpamExternalResourceVerificationTokenRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    @Override
    public Request<CreateIpamExternalResourceVerificationTokenRequest> getDryRunRequest() {
        Request<CreateIpamExternalResourceVerificationTokenRequest> request = new CreateIpamExternalResourceVerificationTokenRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIpamId() != null) {
            sb.append("IpamId: ").append(this.getIpamId()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamExternalResourceVerificationTokenRequest)) {
            return false;
        }
        CreateIpamExternalResourceVerificationTokenRequest other = (CreateIpamExternalResourceVerificationTokenRequest)obj;
        if (other.getIpamId() == null ^ this.getIpamId() == null) {
            return false;
        }
        if (other.getIpamId() != null && !other.getIpamId().equals(this.getIpamId())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIpamId() == null ? 0 : this.getIpamId().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public CreateIpamExternalResourceVerificationTokenRequest clone() {
        return (CreateIpamExternalResourceVerificationTokenRequest)super.clone();
    }
}

