/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Protocol;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PacketHeaderStatement
implements Serializable,
Cloneable {
    private SdkInternalList<String> sourceAddresses;
    private SdkInternalList<String> destinationAddresses;
    private SdkInternalList<String> sourcePorts;
    private SdkInternalList<String> destinationPorts;
    private SdkInternalList<String> sourcePrefixLists;
    private SdkInternalList<String> destinationPrefixLists;
    private SdkInternalList<String> protocols;

    public List<String> getSourceAddresses() {
        if (this.sourceAddresses == null) {
            this.sourceAddresses = new SdkInternalList();
        }
        return this.sourceAddresses;
    }

    public void setSourceAddresses(Collection<String> sourceAddresses) {
        if (sourceAddresses == null) {
            this.sourceAddresses = null;
            return;
        }
        this.sourceAddresses = new SdkInternalList(sourceAddresses);
    }

    public PacketHeaderStatement withSourceAddresses(String ... sourceAddresses) {
        if (this.sourceAddresses == null) {
            this.setSourceAddresses((Collection<String>)new SdkInternalList(sourceAddresses.length));
        }
        for (String ele : sourceAddresses) {
            this.sourceAddresses.add((Object)ele);
        }
        return this;
    }

    public PacketHeaderStatement withSourceAddresses(Collection<String> sourceAddresses) {
        this.setSourceAddresses(sourceAddresses);
        return this;
    }

    public List<String> getDestinationAddresses() {
        if (this.destinationAddresses == null) {
            this.destinationAddresses = new SdkInternalList();
        }
        return this.destinationAddresses;
    }

    public void setDestinationAddresses(Collection<String> destinationAddresses) {
        if (destinationAddresses == null) {
            this.destinationAddresses = null;
            return;
        }
        this.destinationAddresses = new SdkInternalList(destinationAddresses);
    }

    public PacketHeaderStatement withDestinationAddresses(String ... destinationAddresses) {
        if (this.destinationAddresses == null) {
            this.setDestinationAddresses((Collection<String>)new SdkInternalList(destinationAddresses.length));
        }
        for (String ele : destinationAddresses) {
            this.destinationAddresses.add((Object)ele);
        }
        return this;
    }

    public PacketHeaderStatement withDestinationAddresses(Collection<String> destinationAddresses) {
        this.setDestinationAddresses(destinationAddresses);
        return this;
    }

    public List<String> getSourcePorts() {
        if (this.sourcePorts == null) {
            this.sourcePorts = new SdkInternalList();
        }
        return this.sourcePorts;
    }

    public void setSourcePorts(Collection<String> sourcePorts) {
        if (sourcePorts == null) {
            this.sourcePorts = null;
            return;
        }
        this.sourcePorts = new SdkInternalList(sourcePorts);
    }

    public PacketHeaderStatement withSourcePorts(String ... sourcePorts) {
        if (this.sourcePorts == null) {
            this.setSourcePorts((Collection<String>)new SdkInternalList(sourcePorts.length));
        }
        for (String ele : sourcePorts) {
            this.sourcePorts.add((Object)ele);
        }
        return this;
    }

    public PacketHeaderStatement withSourcePorts(Collection<String> sourcePorts) {
        this.setSourcePorts(sourcePorts);
        return this;
    }

    public List<String> getDestinationPorts() {
        if (this.destinationPorts == null) {
            this.destinationPorts = new SdkInternalList();
        }
        return this.destinationPorts;
    }

    public void setDestinationPorts(Collection<String> destinationPorts) {
        if (destinationPorts == null) {
            this.destinationPorts = null;
            return;
        }
        this.destinationPorts = new SdkInternalList(destinationPorts);
    }

    public PacketHeaderStatement withDestinationPorts(String ... destinationPorts) {
        if (this.destinationPorts == null) {
            this.setDestinationPorts((Collection<String>)new SdkInternalList(destinationPorts.length));
        }
        for (String ele : destinationPorts) {
            this.destinationPorts.add((Object)ele);
        }
        return this;
    }

    public PacketHeaderStatement withDestinationPorts(Collection<String> destinationPorts) {
        this.setDestinationPorts(destinationPorts);
        return this;
    }

    public List<String> getSourcePrefixLists() {
        if (this.sourcePrefixLists == null) {
            this.sourcePrefixLists = new SdkInternalList();
        }
        return this.sourcePrefixLists;
    }

    public void setSourcePrefixLists(Collection<String> sourcePrefixLists) {
        if (sourcePrefixLists == null) {
            this.sourcePrefixLists = null;
            return;
        }
        this.sourcePrefixLists = new SdkInternalList(sourcePrefixLists);
    }

    public PacketHeaderStatement withSourcePrefixLists(String ... sourcePrefixLists) {
        if (this.sourcePrefixLists == null) {
            this.setSourcePrefixLists((Collection<String>)new SdkInternalList(sourcePrefixLists.length));
        }
        for (String ele : sourcePrefixLists) {
            this.sourcePrefixLists.add((Object)ele);
        }
        return this;
    }

    public PacketHeaderStatement withSourcePrefixLists(Collection<String> sourcePrefixLists) {
        this.setSourcePrefixLists(sourcePrefixLists);
        return this;
    }

    public List<String> getDestinationPrefixLists() {
        if (this.destinationPrefixLists == null) {
            this.destinationPrefixLists = new SdkInternalList();
        }
        return this.destinationPrefixLists;
    }

    public void setDestinationPrefixLists(Collection<String> destinationPrefixLists) {
        if (destinationPrefixLists == null) {
            this.destinationPrefixLists = null;
            return;
        }
        this.destinationPrefixLists = new SdkInternalList(destinationPrefixLists);
    }

    public PacketHeaderStatement withDestinationPrefixLists(String ... destinationPrefixLists) {
        if (this.destinationPrefixLists == null) {
            this.setDestinationPrefixLists((Collection<String>)new SdkInternalList(destinationPrefixLists.length));
        }
        for (String ele : destinationPrefixLists) {
            this.destinationPrefixLists.add((Object)ele);
        }
        return this;
    }

    public PacketHeaderStatement withDestinationPrefixLists(Collection<String> destinationPrefixLists) {
        this.setDestinationPrefixLists(destinationPrefixLists);
        return this;
    }

    public List<String> getProtocols() {
        if (this.protocols == null) {
            this.protocols = new SdkInternalList();
        }
        return this.protocols;
    }

    public void setProtocols(Collection<String> protocols) {
        if (protocols == null) {
            this.protocols = null;
            return;
        }
        this.protocols = new SdkInternalList(protocols);
    }

    public PacketHeaderStatement withProtocols(String ... protocols) {
        if (this.protocols == null) {
            this.setProtocols((Collection<String>)new SdkInternalList(protocols.length));
        }
        for (String ele : protocols) {
            this.protocols.add((Object)ele);
        }
        return this;
    }

    public PacketHeaderStatement withProtocols(Collection<String> protocols) {
        this.setProtocols(protocols);
        return this;
    }

    public PacketHeaderStatement withProtocols(Protocol ... protocols) {
        SdkInternalList protocolsCopy = new SdkInternalList(protocols.length);
        for (Protocol value : protocols) {
            protocolsCopy.add((Object)value.toString());
        }
        if (this.getProtocols() == null) {
            this.setProtocols((Collection<String>)protocolsCopy);
        } else {
            this.getProtocols().addAll((Collection<String>)protocolsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceAddresses() != null) {
            sb.append("SourceAddresses: ").append(this.getSourceAddresses()).append(",");
        }
        if (this.getDestinationAddresses() != null) {
            sb.append("DestinationAddresses: ").append(this.getDestinationAddresses()).append(",");
        }
        if (this.getSourcePorts() != null) {
            sb.append("SourcePorts: ").append(this.getSourcePorts()).append(",");
        }
        if (this.getDestinationPorts() != null) {
            sb.append("DestinationPorts: ").append(this.getDestinationPorts()).append(",");
        }
        if (this.getSourcePrefixLists() != null) {
            sb.append("SourcePrefixLists: ").append(this.getSourcePrefixLists()).append(",");
        }
        if (this.getDestinationPrefixLists() != null) {
            sb.append("DestinationPrefixLists: ").append(this.getDestinationPrefixLists()).append(",");
        }
        if (this.getProtocols() != null) {
            sb.append("Protocols: ").append(this.getProtocols());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PacketHeaderStatement)) {
            return false;
        }
        PacketHeaderStatement other = (PacketHeaderStatement)obj;
        if (other.getSourceAddresses() == null ^ this.getSourceAddresses() == null) {
            return false;
        }
        if (other.getSourceAddresses() != null && !other.getSourceAddresses().equals(this.getSourceAddresses())) {
            return false;
        }
        if (other.getDestinationAddresses() == null ^ this.getDestinationAddresses() == null) {
            return false;
        }
        if (other.getDestinationAddresses() != null && !other.getDestinationAddresses().equals(this.getDestinationAddresses())) {
            return false;
        }
        if (other.getSourcePorts() == null ^ this.getSourcePorts() == null) {
            return false;
        }
        if (other.getSourcePorts() != null && !other.getSourcePorts().equals(this.getSourcePorts())) {
            return false;
        }
        if (other.getDestinationPorts() == null ^ this.getDestinationPorts() == null) {
            return false;
        }
        if (other.getDestinationPorts() != null && !other.getDestinationPorts().equals(this.getDestinationPorts())) {
            return false;
        }
        if (other.getSourcePrefixLists() == null ^ this.getSourcePrefixLists() == null) {
            return false;
        }
        if (other.getSourcePrefixLists() != null && !other.getSourcePrefixLists().equals(this.getSourcePrefixLists())) {
            return false;
        }
        if (other.getDestinationPrefixLists() == null ^ this.getDestinationPrefixLists() == null) {
            return false;
        }
        if (other.getDestinationPrefixLists() != null && !other.getDestinationPrefixLists().equals(this.getDestinationPrefixLists())) {
            return false;
        }
        if (other.getProtocols() == null ^ this.getProtocols() == null) {
            return false;
        }
        return other.getProtocols() == null || other.getProtocols().equals(this.getProtocols());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceAddresses() == null ? 0 : this.getSourceAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationAddresses() == null ? 0 : this.getDestinationAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getSourcePorts() == null ? 0 : this.getSourcePorts().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationPorts() == null ? 0 : this.getDestinationPorts().hashCode());
        hashCode = 31 * hashCode + (this.getSourcePrefixLists() == null ? 0 : this.getSourcePrefixLists().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationPrefixLists() == null ? 0 : this.getDestinationPrefixLists().hashCode());
        hashCode = 31 * hashCode + (this.getProtocols() == null ? 0 : this.getProtocols().hashCode());
        return hashCode;
    }

    public PacketHeaderStatement clone() {
        try {
            return (PacketHeaderStatement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

