/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import java.nio.ByteBuffer;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchHolder;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeBufferAggregatorHelper;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;

public class HllSketchMergeBufferAggregator
implements BufferAggregator {
    private final ColumnValueSelector<HllSketchHolder> selector;
    private final HllSketchMergeBufferAggregatorHelper helper;

    public HllSketchMergeBufferAggregator(ColumnValueSelector<HllSketchHolder> selector, int lgK, TgtHllType tgtHllType, int size) {
        this.selector = selector;
        this.helper = new HllSketchMergeBufferAggregatorHelper(lgK, tgtHllType, size);
    }

    public void init(ByteBuffer buf, int position) {
        this.helper.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position) {
        HllSketchHolder sketch = (HllSketchHolder)this.selector.getObject();
        if (sketch == null) {
            return;
        }
        Union union = this.helper.getOrCreateUnion(buf, position);
        union.update(sketch.getSketch());
    }

    public Object get(ByteBuffer buf, int position) {
        return HllSketchHolder.of(this.helper.get(buf, position));
    }

    public void close() {
        this.helper.clear();
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("lgK", (Object)this.helper.getLgK());
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        this.helper.relocate(oldPosition, newPosition, oldBuffer, newBuffer);
    }
}

