/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import java.util.Objects;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.OutputChannelMode;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.NotEnoughTemporaryStorageFault;

public class WorkerStorageParameters {
    private static final Logger log = new Logger(WorkerStorageParameters.class);
    private static final double SUPER_SORTER_TMP_STORAGE_USABLE_FRACTION = 0.8;
    private static final long MINIMUM_BASIC_OPERATIONS_BYTES = 1000000000L;
    private static final long MINIMUM_SUPER_SORTER_TMP_STORAGE_BYTES = 1000000000L;
    private final long intermediateSuperSorterStorageMaxLocalBytes;

    private WorkerStorageParameters(long intermediateSuperSorterStorageMaxLocalBytes) {
        this.intermediateSuperSorterStorageMaxLocalBytes = intermediateSuperSorterStorageMaxLocalBytes;
    }

    public static WorkerStorageParameters createProductionInstance(Injector injector, OutputChannelMode outputChannelMode) {
        long tmpStorageBytesPerTask = ((TaskConfig)injector.getInstance(TaskConfig.class)).getTmpStorageBytesPerTask();
        return WorkerStorageParameters.createInstance(tmpStorageBytesPerTask, outputChannelMode.isDurable());
    }

    @VisibleForTesting
    public static WorkerStorageParameters createInstanceForTests(long tmpStorageBytesPerTask) {
        return new WorkerStorageParameters(tmpStorageBytesPerTask);
    }

    public static WorkerStorageParameters createInstance(long tmpStorageBytesPerTask, boolean isIntermediateSuperSorterStorageEnabled) {
        if (!isIntermediateSuperSorterStorageEnabled || tmpStorageBytesPerTask == -1L) {
            return new WorkerStorageParameters(-1L);
        }
        Preconditions.checkArgument((tmpStorageBytesPerTask > 0L ? 1 : 0) != 0, (String)"Temporary storage bytes passed: [%s] should be > 0", (long)tmpStorageBytesPerTask);
        long intermediateSuperSorterStorageMaxLocalBytes = WorkerStorageParameters.computeUsableStorage(tmpStorageBytesPerTask);
        log.info("Intermediate super sorter local storage size: %d bytes", new Object[]{intermediateSuperSorterStorageMaxLocalBytes});
        if (intermediateSuperSorterStorageMaxLocalBytes < 1000000000L) {
            throw new MSQException(new NotEnoughTemporaryStorageFault(WorkerStorageParameters.calculateSuggestedMinTemporaryStorage(), tmpStorageBytesPerTask));
        }
        return new WorkerStorageParameters(intermediateSuperSorterStorageMaxLocalBytes);
    }

    private static long computeUsableStorage(long tmpStorageBytesPerTask) {
        return (long)(0.8 * (double)(tmpStorageBytesPerTask - 1000000000L));
    }

    private static long calculateSuggestedMinTemporaryStorage() {
        return 2250000000L;
    }

    public long getIntermediateSuperSorterStorageMaxLocalBytes() {
        return this.intermediateSuperSorterStorageMaxLocalBytes;
    }

    public boolean isIntermediateStorageLimitConfigured() {
        return this.intermediateSuperSorterStorageMaxLocalBytes != -1L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerStorageParameters that = (WorkerStorageParameters)o;
        return this.intermediateSuperSorterStorageMaxLocalBytes == that.intermediateSuperSorterStorageMaxLocalBytes;
    }

    public int hashCode() {
        return Objects.hash(this.intermediateSuperSorterStorageMaxLocalBytes);
    }

    public String toString() {
        return "WorkerStorageParameters{intermediateSuperSorterStorageMaxLocalBytes=" + this.intermediateSuperSorterStorageMaxLocalBytes + "}";
    }
}

