/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.rpc;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.Worker;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.rpc.MSQResourceUtils;
import org.apache.druid.msq.rpc.ResourcePermissionMapper;
import org.apache.druid.msq.rpc.SketchEncoding;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;
import org.apache.druid.msq.statistics.serde.ClusterByStatisticsSnapshotSerde;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.utils.CloseableUtils;

public class WorkerResource {
    private static final Logger log = new Logger(WorkerResource.class);
    private static final long CHANNEL_DATA_CHUNK_SIZE = 1000000L;
    private static final long GET_CHANNEL_DATA_TIMEOUT = 30000L;
    protected final Worker worker;
    protected final ResourcePermissionMapper permissionMapper;
    protected final AuthorizerMapper authorizerMapper;

    public WorkerResource(Worker worker, ResourcePermissionMapper permissionMapper, AuthorizerMapper authorizerMapper) {
        this.worker = worker;
        this.permissionMapper = permissionMapper;
        this.authorizerMapper = authorizerMapper;
    }

    @GET
    @Path(value="/channels/{queryId}/{stageNumber}/{partitionNumber}")
    @Produces(value={"application/octet-stream"})
    public Response httpGetChannelData(@PathParam(value="queryId") String queryId, @PathParam(value="stageNumber") int stageNumber, @PathParam(value="partitionNumber") int partitionNumber, @QueryParam(value="offset") long offset, @Context HttpServletRequest req) {
        MSQResourceUtils.authorizeQueryRequest(this.permissionMapper, this.authorizerMapper, req, queryId);
        ListenableFuture<InputStream> dataFuture = this.worker.readStageOutput(new StageId(queryId, stageNumber), partitionNumber, offset);
        final AsyncContext asyncContext = req.startAsync();
        final AtomicBoolean responseResolved = new AtomicBoolean();
        asyncContext.setTimeout(30000L);
        asyncContext.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) {
            }

            public void onTimeout(AsyncEvent event) {
                if (responseResolved.compareAndSet(false, true)) {
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    response.setStatus(200);
                    event.getAsyncContext().complete();
                }
            }

            public void onError(AsyncEvent event) {
            }

            public void onStartAsync(AsyncEvent event) {
            }
        });
        final String remoteAddr = req.getRemoteAddr();
        final String requestURI = req.getRequestURI();
        Futures.addCallback(dataFuture, (FutureCallback)new FutureCallback<InputStream>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(InputStream inputStream) {
                if (!responseResolved.compareAndSet(false, true)) {
                    return;
                }
                HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                try (ServletOutputStream outputStream = response.getOutputStream();){
                    if (inputStream == null) {
                        response.setStatus(404);
                    } else {
                        response.setStatus(200);
                        response.setContentType("application/octet-stream");
                        byte[] readBuf = new byte[8192];
                        int firstRead = inputStream.read(readBuf);
                        if (firstRead == -1) {
                            response.setHeader("X-Druid-Frame-Last-Fetch", "yes");
                        } else {
                            long bytesReadTotal = 0L;
                            int bytesReadThisCall = firstRead;
                            do {
                                int bytesToWrite = (int)Math.min(1000000L - bytesReadTotal, (long)bytesReadThisCall);
                                outputStream.write(readBuf, 0, bytesToWrite);
                            } while ((bytesReadTotal += (long)bytesReadThisCall) < 1000000L && (bytesReadThisCall = inputStream.read(readBuf)) != -1);
                        }
                    }
                }
                catch (Exception e2) {
                    log.noStackTrace().warn((Throwable)e2, "Could not respond to request from[%s] to[%s]", new Object[]{remoteAddr, requestURI});
                }
                finally {
                    CloseableUtils.closeAndSuppressExceptions((Closeable)inputStream, e -> log.warn("Failed to close output channel", new Object[0]));
                    asyncContext.complete();
                }
            }

            public void onFailure(Throwable e) {
                if (responseResolved.compareAndSet(false, true)) {
                    try {
                        HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                        response.sendError(500);
                        asyncContext.complete();
                    }
                    catch (Exception e2) {
                        e.addSuppressed(e2);
                    }
                    log.noStackTrace().warn(e, "Request failed from[%s] to[%s]", new Object[]{remoteAddr, requestURI});
                }
            }
        }, (Executor)Execs.directExecutor());
        return null;
    }

    @POST
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/workOrder")
    public Response httpPostWorkOrder(WorkOrder workOrder, @Context HttpServletRequest req) {
        String queryId = workOrder.getQueryDefinition().getQueryId();
        MSQResourceUtils.authorizeQueryRequest(this.permissionMapper, this.authorizerMapper, req, queryId);
        this.worker.postWorkOrder(workOrder);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/resultPartitionBoundaries/{queryId}/{stageNumber}")
    public Response httpPostResultPartitionBoundaries(ClusterByPartitions stagePartitionBoundaries, @PathParam(value="queryId") String queryId, @PathParam(value="stageNumber") int stageNumber, @Context HttpServletRequest req) {
        MSQResourceUtils.authorizeQueryRequest(this.permissionMapper, this.authorizerMapper, req, queryId);
        if (this.worker.postResultPartitionBoundaries(new StageId(queryId, stageNumber), stagePartitionBoundaries)) {
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @POST
    @Path(value="/keyStatistics/{queryId}/{stageNumber}")
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    @Produces(value={"application/json", "application/octet-stream"})
    public Response httpFetchKeyStatistics(@PathParam(value="queryId") String queryId, @PathParam(value="stageNumber") int stageNumber, @QueryParam(value="sketchEncoding") @Nullable SketchEncoding sketchEncoding, @Context HttpServletRequest req) {
        MSQResourceUtils.authorizeQueryRequest(this.permissionMapper, this.authorizerMapper, req, queryId);
        StageId stageId = new StageId(queryId, stageNumber);
        try {
            ClusterByStatisticsSnapshot clusterByStatisticsSnapshot = this.worker.fetchStatisticsSnapshot(stageId);
            if (SketchEncoding.OCTET_STREAM.equals((Object)sketchEncoding)) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).type("application/octet-stream").entity(output -> ClusterByStatisticsSnapshotSerde.serialize(output, clusterByStatisticsSnapshot)).build();
            }
            return Response.status((Response.Status)Response.Status.ACCEPTED).type("application/json").entity((Object)clusterByStatisticsSnapshot).build();
        }
        catch (Exception e) {
            String errorMessage = StringUtils.format((String)"Invalid request for key statistics for query[%s] and stage[%d]", (Object[])new Object[]{queryId, stageNumber});
            log.error((Throwable)e, errorMessage, new Object[0]);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)errorMessage)).build();
        }
    }

    @POST
    @Path(value="/keyStatisticsForTimeChunk/{queryId}/{stageNumber}/{timeChunk}")
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    @Produces(value={"application/json", "application/octet-stream"})
    public Response httpFetchKeyStatisticsWithSnapshot(@PathParam(value="queryId") String queryId, @PathParam(value="stageNumber") int stageNumber, @PathParam(value="timeChunk") long timeChunk, @QueryParam(value="sketchEncoding") @Nullable SketchEncoding sketchEncoding, @Context HttpServletRequest req) {
        MSQResourceUtils.authorizeQueryRequest(this.permissionMapper, this.authorizerMapper, req, queryId);
        StageId stageId = new StageId(queryId, stageNumber);
        try {
            ClusterByStatisticsSnapshot snapshotForTimeChunk = this.worker.fetchStatisticsSnapshotForTimeChunk(stageId, timeChunk);
            if (SketchEncoding.OCTET_STREAM.equals((Object)sketchEncoding)) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).type("application/octet-stream").entity(output -> ClusterByStatisticsSnapshotSerde.serialize(output, snapshotForTimeChunk)).build();
            }
            return Response.status((Response.Status)Response.Status.ACCEPTED).type("application/json").entity((Object)snapshotForTimeChunk).build();
        }
        catch (Exception e) {
            String errorMessage = StringUtils.format((String)"Invalid request for key statistics for query[%s], stage[%d] and timeChunk[%d]", (Object[])new Object[]{queryId, stageNumber, timeChunk});
            log.error((Throwable)e, errorMessage, new Object[0]);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)errorMessage)).build();
        }
    }

    @POST
    @Path(value="/cleanupStage/{queryId}/{stageNumber}")
    public Response httpPostCleanupStage(@PathParam(value="queryId") String queryId, @PathParam(value="stageNumber") int stageNumber, @Context HttpServletRequest req) {
        MSQResourceUtils.authorizeQueryRequest(this.permissionMapper, this.authorizerMapper, req, queryId);
        this.worker.postCleanupStage(new StageId(queryId, stageNumber));
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="/finish")
    public Response httpPostFinish(@Context HttpServletRequest req) {
        MSQResourceUtils.authorizeAdminRequest(this.permissionMapper, this.authorizerMapper, req);
        this.worker.postFinish();
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Produces(value={"application/json; qs=0.9", "application/x-jackson-smile; qs=0.1"})
    @Path(value="/counters")
    public Response httpGetCounters(@Context HttpServletRequest req) {
        MSQResourceUtils.authorizeAdminRequest(this.permissionMapper, this.authorizerMapper, req);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.worker.getCounters()).build();
    }
}

