/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle.output;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import org.apache.druid.frame.channel.ReadableFileFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.file.FrameFile;
import org.apache.druid.msq.shuffle.output.StageOutputReader;

public class FileStageOutputReader
implements StageOutputReader {
    private final FrameFile frameFile;

    public FileStageOutputReader(FrameFile frameFile) {
        this.frameFile = frameFile;
    }

    @Override
    public ListenableFuture<InputStream> readRemotelyFrom(long offset) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.frameFile.file(), "r");
            if (offset >= randomAccessFile.length()) {
                randomAccessFile.close();
                return Futures.immediateFuture((Object)new ByteArrayInputStream(ByteArrays.EMPTY_ARRAY));
            }
            randomAccessFile.seek(offset);
            return Futures.immediateFuture((Object)Channels.newInputStream(randomAccessFile.getChannel()));
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    @Override
    public ReadableFrameChannel readLocally() {
        return new ReadableFileFrameChannel(this.frameFile.newReference());
    }

    @Override
    public void close() throws IOException {
        this.frameFile.close();
    }
}

