/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.parser;

import com.google.common.base.Joiner;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSetOption;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.SourceStringReader;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.sql.calcite.parser.DruidSqlParserImplFactory;
import org.apache.druid.sql.calcite.parser.ParseException;
import org.apache.druid.sql.calcite.parser.StatementAndSetContext;
import org.apache.druid.sql.calcite.parser.Token;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.DruidConformance;

public class DruidSqlParser {
    public static final SqlParser.Config PARSER_CONFIG = SqlParser.config().withCaseSensitive(true).withUnquotedCasing(Casing.UNCHANGED).withQuotedCasing(Casing.UNCHANGED).withQuoting(Quoting.DOUBLE_QUOTE).withConformance((SqlConformance)DruidConformance.instance()).withParserFactory((SqlParserImplFactory)new DruidSqlParserImplFactory());
    private static final Joiner SPACE_JOINER = Joiner.on((String)" ");
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");

    private DruidSqlParser() {
    }

    public static StatementAndSetContext parse(String sql, boolean allowSetStatements) {
        try {
            SqlParser parser = SqlParser.create((Reader)new SourceStringReader(sql), (SqlParser.Config)PARSER_CONFIG);
            SqlNodeList sqlNode = parser.parseStmtList();
            return DruidSqlParser.processStatementList((SqlNode)sqlNode, allowSetStatements);
        }
        catch (SqlParseException e) {
            throw DruidSqlParser.translateParseException(e);
        }
    }

    private static StatementAndSetContext processStatementList(SqlNode root, boolean allowSetStatements) {
        if (root instanceof SqlNodeList) {
            LinkedHashMap<String, Object> setContext = new LinkedHashMap<String, Object>();
            SqlNodeList nodeList = (SqlNodeList)root;
            if (!allowSetStatements && nodeList.size() > 1) {
                throw InvalidSqlInput.exception((String)"SQL query string must contain only a single statement", (Object[])new Object[0]);
            }
            boolean isMissingDruidStatementNode = true;
            for (int i = 0; i < nodeList.size(); ++i) {
                SqlNode sqlNode = nodeList.get(i);
                if (sqlNode instanceof SqlSetOption) {
                    SqlSetOption sqlSetOption = (SqlSetOption)sqlNode;
                    if (!(sqlSetOption.getValue() instanceof SqlLiteral)) {
                        throw InvalidSqlInput.exception((String)"Assigned value must be a literal for SET statement[%s]", (Object[])new Object[]{sqlSetOption.toSqlString(CalciteSqlDialect.DEFAULT)});
                    }
                    setContext.put(sqlSetOption.getName().getSimple(), DruidSqlParser.sqlLiteralToContextValue((SqlLiteral)sqlSetOption.getValue()));
                    continue;
                }
                if (i < nodeList.size() - 1) {
                    throw InvalidSqlInput.exception((String)"Only SET statements can appear before the final statement in a statement list, but found non-SET statement[%s]", (Object[])new Object[]{sqlNode.toSqlString(CalciteSqlDialect.DEFAULT)});
                }
                root = sqlNode;
                isMissingDruidStatementNode = false;
            }
            if (isMissingDruidStatementNode) {
                throw InvalidSqlInput.exception((String)"Statement list is missing a non-SET statement to execute", (Object[])new Object[0]);
            }
            return new StatementAndSetContext(root, setContext);
        }
        return new StatementAndSetContext(root, Collections.emptyMap());
    }

    @Nullable
    static Object sqlLiteralToContextValue(SqlLiteral literal) {
        if (SqlUtil.isNullLiteral((SqlNode)literal, (boolean)false)) {
            return null;
        }
        if (SqlTypeName.CHAR_TYPES.contains(literal.getTypeName())) {
            return ((NlsString)literal.getValue()).getValue();
        }
        if (SqlTypeName.BOOLEAN_TYPES.contains(literal.getTypeName())) {
            return literal.getValue();
        }
        if (SqlTypeName.NUMERIC_TYPES.contains(literal.getTypeName())) {
            Number number = (Number)literal.getValue();
            if (number instanceof BigDecimal && number.equals(BigDecimal.valueOf(number.longValue()))) {
                return number.longValue();
            }
            if (number instanceof BigInteger && number.equals(BigInteger.valueOf(number.longValue()))) {
                return number.longValue();
            }
            if (number instanceof BigDecimal && number.equals(BigDecimal.valueOf(number.doubleValue()))) {
                return number.doubleValue();
            }
            return number.toString();
        }
        if (literal.getTypeName() == SqlTypeName.DATE) {
            return Calcites.CALCITE_DATE_PARSER.parse(literal.getValue().toString()).toString();
        }
        if (literal.getTypeName() == SqlTypeName.TIMESTAMP) {
            return Calcites.CALCITE_TIMESTAMP_PARSER.parse(literal.getValue().toString()).toString();
        }
        throw InvalidSqlInput.exception((String)"Unsupported type for SET[%s]", (Object[])new Object[]{literal.getTypeName()});
    }

    private static DruidException translateParseException(SqlParseException e) {
        Throwable cause = e.getCause();
        if (cause instanceof DruidException) {
            return (DruidException)cause;
        }
        if (cause instanceof ParseException) {
            ParseException parseException = (ParseException)cause;
            SqlParserPos failurePosition = e.getPos();
            if (parseException.expectedTokenSequences == null) {
                return DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).withErrorCode("invalidInput").build((Throwable)e, "%s", new Object[]{e.getMessage()}).withContext("sourceType", (Object)"sql");
            }
            String theUnexpectedToken = DruidSqlParser.getUnexpectedTokenString(parseException);
            String[] tokenDictionary = e.getTokenImages();
            int[][] expectedTokenSequences = e.getExpectedTokenSequences();
            ArrayList<String> expectedTokens = new ArrayList<String>(expectedTokenSequences.length);
            for (int[] expectedTokenSequence : expectedTokenSequences) {
                Object[] strings = new String[expectedTokenSequence.length];
                for (int i = 0; i < expectedTokenSequence.length; ++i) {
                    strings[i] = tokenDictionary[expectedTokenSequence[i]];
                }
                expectedTokens.add(SPACE_JOINER.join(strings));
            }
            return InvalidSqlInput.exception((Throwable)e, (String)"Received an unexpected token [%s] (line [%s], column [%s]), acceptable options: [%s]", (Object[])new Object[]{theUnexpectedToken, failurePosition.getLineNum(), failurePosition.getColumnNum(), COMMA_JOINER.join(expectedTokens)}).withContext("line", (Object)failurePosition.getLineNum()).withContext("column", (Object)failurePosition.getColumnNum()).withContext("endLine", (Object)failurePosition.getEndLineNum()).withContext("endColumn", (Object)failurePosition.getEndColumnNum()).withContext("token", (Object)theUnexpectedToken).withContext("expected", expectedTokens);
        }
        return InvalidSqlInput.exception((String)e.getMessage(), (Object[])new Object[0]);
    }

    private static String getUnexpectedTokenString(ParseException parseException) {
        int maxSize = 0;
        for (int[] ints : parseException.expectedTokenSequences) {
            if (maxSize >= ints.length) continue;
            maxSize = ints.length;
        }
        StringBuilder bob = new StringBuilder();
        Token tok = parseException.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                bob.append(" ");
            }
            if (tok.kind == 0) {
                bob.append("<EOF>");
                break;
            }
            block13: for (int i1 = 0; i1 < tok.image.length(); ++i1) {
                switch (tok.image.charAt(i1)) {
                    case '\u0000': {
                        continue block13;
                    }
                    case '\b': {
                        bob.append("\\b");
                        continue block13;
                    }
                    case '\t': {
                        bob.append("\\t");
                        continue block13;
                    }
                    case '\n': {
                        bob.append("\\n");
                        continue block13;
                    }
                    case '\f': {
                        bob.append("\\f");
                        continue block13;
                    }
                    case '\r': {
                        bob.append("\\r");
                        continue block13;
                    }
                    case '\"': {
                        bob.append("\\\"");
                        continue block13;
                    }
                    case '\'': {
                        bob.append("\\'");
                        continue block13;
                    }
                    case '\\': {
                        bob.append("\\\\");
                        continue block13;
                    }
                    default: {
                        char ch = tok.image.charAt(i1);
                        if (ch < ' ' || ch > '~') {
                            String s = "0000" + Integer.toString(ch, 16);
                            bob.append("\\u").append(s.substring(s.length() - 4, s.length()));
                            continue block13;
                        }
                        bob.append(ch);
                    }
                }
            }
            tok = tok.next;
        }
        return bob.toString();
    }
}

