/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel.logical;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalConvention;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalNode;

public class DruidProject
extends Project
implements DruidLogicalNode {
    public DruidProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traitSet, input, projects, rowType);
        assert (this.getConvention() instanceof DruidLogicalConvention);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double cost = 0.0;
        double rowCount = mq.getRowCount(this.getInput());
        for (RexNode rexNode : this.getProjects()) {
            if (rexNode.isA(SqlKind.INPUT_REF)) {
                cost += 0.0;
            }
            if (rexNode.getType().getSqlTypeName() == SqlTypeName.BOOLEAN || rexNode.isA(SqlKind.CAST)) {
                cost += 0.0;
                continue;
            }
            if (rexNode.isA((Collection)ImmutableSet.of((Object)SqlKind.INPUT_REF, (Object)SqlKind.LITERAL))) continue;
            cost += 0.25;
        }
        return planner.getCostFactory().makeCost(0.0, Math.max(cost * rowCount, 1.0E-6), 0.0);
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new DruidProject(this.getCluster(), traitSet, input, (List<? extends RexNode>)this.exps, rowType);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("druid", (Object)"logical");
    }

    public static DruidProject create(RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        RelOptCluster cluster = input.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = input.getTraitSet().replaceIfs((RelTraitDef)RelCollationTraitDef.INSTANCE, () -> RelMdCollation.project((RelMetadataQuery)mq, (RelNode)input, (List)projects));
        return new DruidProject(cluster, traitSet, input, projects, rowType);
    }
}

