/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule.logical;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.druid.error.DruidException;
import org.apache.druid.sql.calcite.rule.logical.LogicalUnnest;

public class UnnestInputCleanupRule
extends RelOptRule
implements SubstitutionRule {
    public UnnestInputCleanupRule() {
        super(UnnestInputCleanupRule.operand(LogicalUnnest.class, (RelOptRuleOperand)UnnestInputCleanupRule.operand(Project.class, (RelOptRuleOperandChildren)UnnestInputCleanupRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalUnnest unnest = (LogicalUnnest)call.rel(0);
        Project oldProject = (Project)call.rel(1);
        ImmutableBitSet input = RelOptUtil.InputFinder.analyze((RexNode)unnest.unnestExpr).build();
        if (input.isEmpty()) {
            throw DruidException.defensive((String)"Found an unbound unnest expression.", (Object[])new Object[0]);
        }
        if (!(unnest.unnestExpr instanceof RexInputRef)) {
            return;
        }
        if (input.cardinality() != 1) {
            return;
        }
        RelBuilder builder = call.builder();
        RexBuilder rexBuilder = builder.getRexBuilder();
        int inputIndex = input.nextSetBit(0);
        ArrayList<RexNode> newProjects = new ArrayList<RexNode>(oldProject.getProjects());
        RexNode unnestInput = (RexNode)newProjects.get(inputIndex);
        newProjects.set(inputIndex, null);
        RexNode newUnnestExpr = (RexNode)unnestInput.accept((RexVisitor)new ExpressionPullerRexShuttle(newProjects, inputIndex));
        if (newUnnestExpr instanceof RexInputRef) {
            return;
        }
        if (newProjects.get(inputIndex) == null) {
            newProjects.set(inputIndex, (RexNode)rexBuilder.makeInputRef(oldProject.getInput(), 0));
        }
        RelNode newInputRel = builder.push(oldProject.getInput()).project(newProjects).build();
        LogicalUnnest newUnnest = new LogicalUnnest(unnest.getCluster(), unnest.getTraitSet(), newInputRel, newUnnestExpr, unnest.unnestFieldType, unnest.filter);
        builder.push((RelNode)newUnnest);
        ArrayList<RexNode> projectFields = new ArrayList<RexNode>((Collection<RexNode>)builder.fields());
        int hideCount = newProjects.size() - oldProject.getProjects().size();
        for (int i = 0; i < hideCount; ++i) {
            projectFields.remove(unnest.getRowType().getFieldCount() - 2);
        }
        projectFields.set(inputIndex, newUnnestExpr);
        builder.project(projectFields, (Iterable)ImmutableSet.of(), true);
        RelNode build = builder.build();
        call.transformTo(build);
        call.getPlanner().prune((RelNode)unnest);
    }

    private static class ExpressionPullerRexShuttle
    extends RexShuttle {
        private final List<RexNode> projects;

        private ExpressionPullerRexShuttle(List<RexNode> projects, int replaceableIndex) {
            this.projects = projects;
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            int newIndex = this.projects.indexOf(inputRef);
            if (newIndex < 0) {
                newIndex = this.projects.size();
                this.projects.add((RexNode)inputRef);
            }
            if (newIndex == inputRef.getIndex()) {
                return inputRef;
            }
            return new RexInputRef(newIndex, inputRef.getType());
        }
    }
}

