/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Set;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.druid.query.DataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.external.ExternalTableScan;
import org.apache.druid.sql.calcite.table.DruidTable;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class ExternalTable
extends DruidTable {
    private final DataSource dataSource;
    private final ObjectMapper objectMapper;
    private final Supplier<Set<String>> inputSourceTypeSupplier;
    private RelDataType rowType;

    public ExternalTable(DataSource dataSource, RowSignature rowSignature, ObjectMapper objectMapper, Supplier<Set<String>> inputSourceTypesSupplier) {
        super(rowSignature);
        this.dataSource = (DataSource)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.objectMapper = objectMapper;
        this.inputSourceTypeSupplier = inputSourceTypesSupplier;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public boolean isJoinable() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.rowType == null) {
            this.rowType = RowSignatures.toRelDataType(this.getRowSignature(), typeFactory, true);
        }
        return this.rowType;
    }

    public Supplier<Set<String>> getInputSourceTypeSupplier() {
        return this.inputSourceTypeSupplier;
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return new ExternalTableScan(context.getCluster(), this.objectMapper, this);
    }

    @Override
    public String toString() {
        return "ExternalTable{dataSource=" + this.dataSource + ", rowSignature=" + this.getRowSignature() + "}";
    }
}

