/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.concurrent.ThreadLocalRandom;

public class DeterminePartitionsJobSampler {
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32();
    private final int samplingFactor;
    private final int sampledTargetPartitionSize;
    private final int sampledMaxRowsPerSegment;

    public DeterminePartitionsJobSampler(int samplingFactor, int targetPartitionSize, int maxRowsPerSegment) {
        this.samplingFactor = Math.max(samplingFactor, 1);
        this.sampledTargetPartitionSize = targetPartitionSize / this.samplingFactor;
        this.sampledMaxRowsPerSegment = maxRowsPerSegment / this.samplingFactor;
    }

    boolean shouldEmitRow(byte[] groupKeyBytes) {
        return this.samplingFactor == 1 || HASH_FUNCTION.hashBytes(groupKeyBytes).asInt() % this.samplingFactor == 0;
    }

    boolean shouldEmitRow() {
        return this.samplingFactor == 1 || ThreadLocalRandom.current().nextInt(this.samplingFactor) == 0;
    }

    public int getSampledTargetPartitionSize() {
        return this.sampledTargetPartitionSize;
    }

    public int getSampledMaxRowsPerSegment() {
        return this.sampledMaxRowsPerSegment;
    }
}

