/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexingPhaseProgress;
import org.apache.druid.indexing.common.task.batch.parallel.SinglePhaseSubTaskSpec;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskReport;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskSpec;
import org.apache.druid.indexing.common.task.batch.parallel.TaskHistory;

public interface ParallelIndexTaskRunner<SubTaskType extends Task, SubTaskReportType extends SubTaskReport> {
    public String getName();

    public TaskState run() throws Exception;

    public void stopGracefully(String var1);

    public String getStopReason();

    public void collectReport(SubTaskReportType var1);

    public Map<String, SubTaskReportType> getReports();

    public ParallelIndexingPhaseProgress getProgress();

    public Set<String> getRunningTaskIds();

    public List<SubTaskSpec<SubTaskType>> getSubTaskSpecs();

    public List<SubTaskSpec<SubTaskType>> getRunningSubTaskSpecs();

    public List<SubTaskSpec<SubTaskType>> getCompleteSubTaskSpecs();

    @Nullable
    public SubTaskSpec<SubTaskType> getSubTaskSpec(String var1);

    @Nullable
    public SubTaskSpecStatus getSubTaskState(String var1);

    @Nullable
    public TaskHistory<SubTaskType> getCompleteSubTaskSpecAttemptHistory(String var1);

    public static class SubTaskSpecStatus {
        private final SinglePhaseSubTaskSpec spec;
        @Nullable
        private final TaskStatusPlus currentStatus;
        private final List<TaskStatusPlus> taskHistory;

        @JsonCreator
        public SubTaskSpecStatus(@JsonProperty(value="spec") SinglePhaseSubTaskSpec spec, @JsonProperty(value="currentStatus") @Nullable TaskStatusPlus currentStatus, @JsonProperty(value="taskHistory") List<TaskStatusPlus> taskHistory) {
            this.spec = spec;
            this.currentStatus = currentStatus;
            this.taskHistory = taskHistory;
        }

        @JsonProperty
        public SinglePhaseSubTaskSpec getSpec() {
            return this.spec;
        }

        @JsonProperty
        @Nullable
        public TaskStatusPlus getCurrentStatus() {
            return this.currentStatus;
        }

        @JsonProperty
        public List<TaskStatusPlus> getTaskHistory() {
            return this.taskHistory;
        }
    }
}

