/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;

public class NoticesQueue<T> {
    @GuardedBy(value="this")
    private final LinkedHashSet<T> queue = new LinkedHashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T item) {
        Preconditions.checkNotNull(item, (Object)"item");
        NoticesQueue noticesQueue = this;
        synchronized (noticesQueue) {
            this.queue.add(item);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T poll(long timeoutMillis) throws InterruptedException {
        NoticesQueue noticesQueue = this;
        synchronized (noticesQueue) {
            long timeoutAt = System.currentTimeMillis() + timeoutMillis;
            long waitMillis = timeoutMillis;
            while (this.queue.isEmpty() && waitMillis > 0L) {
                this.wait(waitMillis);
                waitMillis = timeoutAt - System.currentTimeMillis();
            }
            Iterator it = this.queue.iterator();
            if (it.hasNext()) {
                Object item = it.next();
                it.remove();
                return (T)item;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        NoticesQueue noticesQueue = this;
        synchronized (noticesQueue) {
            return this.queue.size();
        }
    }
}

