/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.sql.SqlDialect;

public final class SqlDialects {
    private SqlDialects() {
    }

    public static SqlDialect.Context createContext(DatabaseMetaData databaseMetaData) {
        String databaseVersion;
        int databaseMinorVersion;
        int databaseMajorVersion;
        String databaseProductName;
        try {
            databaseProductName = databaseMetaData.getDatabaseProductName();
            databaseMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            databaseMinorVersion = databaseMetaData.getDatabaseMinorVersion();
            databaseVersion = databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException e) {
            throw new RuntimeException("while detecting database product", e);
        }
        String quoteString = SqlDialects.getIdentifierQuoteString(databaseMetaData);
        NullCollation nullCollation = SqlDialects.getNullCollation(databaseMetaData);
        Casing unquotedCasing = SqlDialects.getCasing(databaseMetaData, false);
        Casing quotedCasing = SqlDialects.getCasing(databaseMetaData, true);
        boolean caseSensitive = SqlDialects.isCaseSensitive(databaseMetaData);
        SqlDialect.Context c = SqlDialect.EMPTY_CONTEXT.withDatabaseProductName(databaseProductName).withDatabaseMajorVersion(databaseMajorVersion).withDatabaseMinorVersion(databaseMinorVersion).withDatabaseVersion(databaseVersion).withIdentifierQuoteString(quoteString).withUnquotedCasing(unquotedCasing).withQuotedCasing(quotedCasing).withCaseSensitive(caseSensitive).withNullCollation(nullCollation);
        return c;
    }

    private static String getIdentifierQuoteString(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.getIdentifierQuoteString();
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("cannot deduce identifier quote string", e);
        }
    }

    private static Casing getCasing(DatabaseMetaData databaseMetaData, boolean quoted) {
        try {
            if (quoted ? databaseMetaData.storesUpperCaseQuotedIdentifiers() : databaseMetaData.storesUpperCaseIdentifiers()) {
                return Casing.TO_UPPER;
            }
            if (quoted ? databaseMetaData.storesLowerCaseQuotedIdentifiers() : databaseMetaData.storesLowerCaseIdentifiers()) {
                return Casing.TO_LOWER;
            }
            if (quoted ? databaseMetaData.storesMixedCaseQuotedIdentifiers() || databaseMetaData.supportsMixedCaseQuotedIdentifiers() : databaseMetaData.storesMixedCaseIdentifiers() || databaseMetaData.supportsMixedCaseIdentifiers()) {
                return Casing.UNCHANGED;
            }
            return Casing.UNCHANGED;
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("cannot deduce casing", e);
        }
    }

    private static boolean isCaseSensitive(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.supportsMixedCaseIdentifiers() || databaseMetaData.supportsMixedCaseQuotedIdentifiers();
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("cannot deduce case-sensitivity", e);
        }
    }

    private static NullCollation getNullCollation(DatabaseMetaData databaseMetaData) {
        try {
            if (databaseMetaData.nullsAreSortedAtEnd()) {
                return NullCollation.LAST;
            }
            if (databaseMetaData.nullsAreSortedAtStart()) {
                return NullCollation.FIRST;
            }
            if (databaseMetaData.nullsAreSortedLow()) {
                return NullCollation.LOW;
            }
            if (databaseMetaData.nullsAreSortedHigh()) {
                return NullCollation.HIGH;
            }
            if (SqlDialects.isBigQuery(databaseMetaData)) {
                return NullCollation.LOW;
            }
            throw new IllegalArgumentException("cannot deduce null collation");
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("cannot deduce null collation", e);
        }
    }

    private static boolean isBigQuery(DatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.getDatabaseProductName().equals("Google Big Query");
    }
}

