/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.Request;

public class ClientUtils {
    @Nullable
    public static String pickOneHost(DruidNodeDiscovery druidNodeDiscovery) {
        Iterator<DiscoveryDruidNode> iter = druidNodeDiscovery.getAllNodes().iterator();
        ArrayList discoveryDruidNodeList = Lists.newArrayList(iter);
        if (!discoveryDruidNodeList.isEmpty()) {
            DiscoveryDruidNode node = (DiscoveryDruidNode)discoveryDruidNodeList.get(ThreadLocalRandom.current().nextInt(discoveryDruidNodeList.size()));
            return StringUtils.format((String)"%s://%s", (Object[])new Object[]{node.getDruidNode().getServiceScheme(), node.getDruidNode().getHostAndPortToUse()});
        }
        return null;
    }

    public static Request withUrl(Request old, URL url) {
        Request req = new Request(old.getMethod(), url);
        req.addHeaderValues(old.getHeaders());
        if (old.hasContent()) {
            req.setContent(old.getContent().copy());
        }
        return req;
    }
}

