/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.messages.client;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.messages.MessageBatch;
import org.apache.druid.messages.client.MessageListener;
import org.apache.druid.messages.client.MessageRelayClient;
import org.apache.druid.rpc.ServiceClosedException;
import org.apache.druid.server.DruidNode;

public class MessageRelay<MessageType>
implements Closeable {
    private static final Logger log = new Logger(MessageRelay.class);
    public static final long INIT = -1L;
    private final String selfHost;
    private final DruidNode serverNode;
    private final MessageRelayClient<MessageType> client;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Collector collector;

    public MessageRelay(String selfHost, DruidNode serverNode, MessageRelayClient<MessageType> client, MessageListener<MessageType> listener) {
        this.selfHost = selfHost;
        this.serverNode = serverNode;
        this.client = client;
        this.collector = new Collector(listener);
    }

    public void start() {
        this.collector.start();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.collector.stop();
        }
    }

    private class Collector {
        private final MessageListener<MessageType> listener;
        private final AtomicLong epoch = new AtomicLong(-1L);
        private final AtomicLong watermark = new AtomicLong(-1L);
        private final AtomicReference<ListenableFuture<?>> currentCall = new AtomicReference();

        public Collector(MessageListener<MessageType> listener) {
            this.listener = listener;
        }

        private void start() {
            if (!this.watermark.compareAndSet(-1L, 0L)) {
                throw new ISE("Already started", new Object[0]);
            }
            this.listener.serverAdded(MessageRelay.this.serverNode);
            this.issueNextGetMessagesCall();
        }

        private void issueNextGetMessagesCall() {
            if (MessageRelay.this.closed.get()) {
                return;
            }
            final long theEpoch = this.epoch.get();
            final long theWatermark = this.watermark.get();
            log.debug("Getting messages from server[%s] for client[%s] (current state: epoch[%s] watermark[%s]).", new Object[]{MessageRelay.this.serverNode.getHostAndPortToUse(), MessageRelay.this.selfHost, theEpoch, theWatermark});
            final ListenableFuture future = MessageRelay.this.client.getMessages(MessageRelay.this.selfHost, theEpoch, theWatermark);
            if (!this.currentCall.compareAndSet(null, future)) {
                log.error("Fatal error: too many outgoing calls to server[%s] for client[%s] (current state: epoch[%s] watermark[%s]). Closing collector.", new Object[]{MessageRelay.this.serverNode.getHostAndPortToUse(), MessageRelay.this.selfHost, theEpoch, theWatermark});
                MessageRelay.this.close();
                return;
            }
            Futures.addCallback(future, (FutureCallback)new FutureCallback<MessageBatch<MessageType>>(){

                public void onSuccess(MessageBatch<MessageType> result) {
                    log.debug("Received message batch: %s", new Object[]{result});
                    Collector.this.currentCall.compareAndSet(future, null);
                    long endWatermark = result.getStartWatermark() + (long)result.getMessages().size();
                    if (theEpoch == -1L) {
                        Collector.this.epoch.set(result.getEpoch());
                        Collector.this.watermark.set(endWatermark);
                    } else if (Collector.this.epoch.get() != result.getEpoch() || !Collector.this.watermark.compareAndSet(result.getStartWatermark(), endWatermark)) {
                        log.error("Incorrect epoch + watermark from server[%s] for client[%s] (expected[%s:%s] but got[%s:%s]). Closing collector.", new Object[]{MessageRelay.this.serverNode.getHostAndPortToUse(), MessageRelay.this.selfHost, theEpoch, theWatermark, result.getEpoch(), result.getStartWatermark()});
                        MessageRelay.this.close();
                        return;
                    }
                    for (Object message : result.getMessages()) {
                        try {
                            Collector.this.listener.messageReceived(message);
                        }
                        catch (Throwable e) {
                            log.warn(e, "Failed to handle message[%s] from server[%s] for client[%s].", new Object[]{message, MessageRelay.this.selfHost, MessageRelay.this.serverNode.getHostAndPortToUse()});
                        }
                    }
                    Collector.this.issueNextGetMessagesCall();
                }

                public void onFailure(Throwable e) {
                    Collector.this.currentCall.compareAndSet(future, null);
                    if (!(e instanceof CancellationException) && !(e instanceof ServiceClosedException)) {
                        log.error(e, "Fatal error contacting server[%s] for client[%s] (current state: epoch[%s] watermark[%s]). Closing collector.", new Object[]{MessageRelay.this.serverNode.getHostAndPortToUse(), MessageRelay.this.selfHost, theEpoch, theWatermark});
                    }
                    MessageRelay.this.close();
                }
            }, (Executor)Execs.directExecutor());
        }

        public void stop() {
            ListenableFuture future = this.currentCall.getAndSet(null);
            if (future != null) {
                future.cancel(true);
            }
            try {
                this.listener.serverRemoved(MessageRelay.this.serverNode);
            }
            catch (Throwable e) {
                log.warn(e, "Failed to close server[%s]", new Object[]{MessageRelay.this.serverNode.getHostAndPortToUse()});
            }
        }
    }
}

