/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.base.Supplier;
import com.google.inject.Inject;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthorizerMapper;

@LazySingleton
public class QueryLifecycleFactory {
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final QuerySegmentWalker texasRanger;
    private final GenericQueryMetricsFactory queryMetricsFactory;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;
    private final AuthorizerMapper authorizerMapper;
    private final DefaultQueryConfig defaultQueryConfig;
    private final AuthConfig authConfig;
    private final PolicyEnforcer policyEnforcer;

    @Inject
    public QueryLifecycleFactory(QueryRunnerFactoryConglomerate conglomerate, QuerySegmentWalker texasRanger, GenericQueryMetricsFactory queryMetricsFactory, ServiceEmitter emitter, RequestLogger requestLogger, AuthConfig authConfig, PolicyEnforcer policyEnforcer, AuthorizerMapper authorizerMapper, Supplier<DefaultQueryConfig> queryConfigSupplier) {
        this.conglomerate = conglomerate;
        this.texasRanger = texasRanger;
        this.queryMetricsFactory = queryMetricsFactory;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
        this.authorizerMapper = authorizerMapper;
        this.defaultQueryConfig = (DefaultQueryConfig)queryConfigSupplier.get();
        this.authConfig = authConfig;
        this.policyEnforcer = policyEnforcer;
    }

    public QueryLifecycle factorize() {
        return new QueryLifecycle(this.conglomerate, this.texasRanger, this.queryMetricsFactory, this.emitter, this.requestLogger, this.authorizerMapper, this.defaultQueryConfig, this.authConfig, this.policyEnforcer, System.currentTimeMillis(), System.nanoTime());
    }
}

