/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.emitter.core.EventMap;
import org.apache.druid.query.Query;
import org.apache.druid.server.QueryStats;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.log.RequestLogEvent;
import org.joda.time.DateTime;

public final class DefaultRequestLogEvent
implements RequestLogEvent {
    private final ImmutableMap<String, String> serviceDimensions;
    private final String feed;
    private final RequestLogLine request;

    DefaultRequestLogEvent(ImmutableMap<String, String> serviceDimensions, String feed, RequestLogLine request) {
        this.serviceDimensions = serviceDimensions;
        this.request = request;
        this.feed = feed;
    }

    @JsonValue(value=false)
    public EventMap toMap() {
        EventMap.Builder builder = EventMap.builder().put("feed", (Object)this.getFeed()).put("timestamp", (Object)this.getCreatedTime()).put("service", (Object)this.getService()).put("host", (Object)this.getHost()).putNonNull("query", (Object)this.getQuery());
        if (this.getSql() != null) {
            builder.put("sql", (Object)this.getSql()).put("sqlQueryContext", this.getSqlQueryContext());
        }
        builder.put("remoteAddr", (Object)this.getRemoteAddr()).put("queryStats", (Object)this.getQueryStats());
        return builder.build();
    }

    @JsonProperty(value="feed")
    public String getFeed() {
        return this.feed;
    }

    @JsonProperty(value="timestamp")
    public DateTime getCreatedTime() {
        return this.request.getTimestamp();
    }

    @JsonProperty(value="service")
    public String getService() {
        return (String)this.serviceDimensions.get((Object)"service");
    }

    @JsonProperty(value="host")
    public String getHost() {
        return (String)this.serviceDimensions.get((Object)"host");
    }

    @JsonProperty(value="query")
    public Query getQuery() {
        return this.request.getQuery();
    }

    @JsonProperty(value="sql")
    public String getSql() {
        return this.request.getSql();
    }

    @JsonProperty(value="sqlQueryContext")
    public Map<String, Object> getSqlQueryContext() {
        return this.request.getSqlQueryContext();
    }

    @JsonProperty(value="remoteAddr")
    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    @JsonProperty(value="queryStats")
    public QueryStats getQueryStats() {
        return this.request.getQueryStats();
    }
}

