/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.log;

import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.log.RequestLogEventBuilderFactory;
import org.apache.druid.server.log.RequestLogger;

public class EmittingRequestLogger
implements RequestLogger {
    private final ServiceEmitter emitter;
    private final String feed;
    private final RequestLogEventBuilderFactory requestLogEventBuilderFactory;

    EmittingRequestLogger(ServiceEmitter emitter, String feed, RequestLogEventBuilderFactory requestLogEventBuilderFactory) {
        this.emitter = emitter;
        this.feed = feed;
        this.requestLogEventBuilderFactory = requestLogEventBuilderFactory;
    }

    @Override
    public void logNativeQuery(RequestLogLine requestLogLine) {
        this.emitter.emit(this.requestLogEventBuilderFactory.createRequestLogEventBuilder(this.feed, requestLogLine));
    }

    @Override
    public void logSqlQuery(RequestLogLine requestLogLine) {
        this.emitter.emit(this.requestLogEventBuilderFactory.createRequestLogEventBuilder(this.feed, requestLogLine));
    }

    public String toString() {
        return "EmittingRequestLogger{emitter=" + this.emitter + ", feed='" + this.feed + "', requestLogEventBuilderFactory=" + this.requestLogEventBuilderFactory + "}";
    }
}

