/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.cache;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.LookupNodeService;
import org.apache.druid.server.http.HostAndPortWithScheme;

public class LookupNodeDiscovery {
    private final DruidNodeDiscovery druidNodeDiscovery;

    LookupNodeDiscovery(DruidNodeDiscoveryProvider druidNodeDiscoveryProvider) {
        this.druidNodeDiscovery = druidNodeDiscoveryProvider.getForService("lookupNodeService");
    }

    public Collection<HostAndPortWithScheme> getNodesInTier(String tier) {
        return Collections2.transform((Collection)Collections2.filter(this.druidNodeDiscovery.getAllNodes(), node -> {
            if (node == null) {
                return false;
            }
            LookupNodeService lookupNodeService = node.getService("lookupNodeService", LookupNodeService.class);
            return lookupNodeService != null && tier.equals(lookupNodeService.getLookupTier());
        }), input -> HostAndPortWithScheme.fromString(input.getDruidNode().getServiceScheme(), input.getDruidNode().getHostAndPortToUse()));
    }

    public Set<String> getAllTiers() {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        this.druidNodeDiscovery.getAllNodes().forEach(node -> {
            LookupNodeService lookupService = node.getService("lookupNodeService", LookupNodeService.class);
            if (lookupService != null) {
                builder.add((Object)lookupService.getLookupTier());
            }
        });
        return builder.build();
    }
}

