/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3;

import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.druid.storage.s3.S3SSECustomConfig;
import org.apache.druid.storage.s3.ServerSideEncryption;

class CustomServerSideEncryption
implements ServerSideEncryption {
    private final SSECustomerKey key;

    @JsonCreator
    CustomServerSideEncryption(@JacksonInject S3SSECustomConfig config) {
        this.key = new SSECustomerKey(config.getBase64EncodedKey());
    }

    @Override
    public PutObjectRequest decorate(PutObjectRequest request) {
        return request.withSSECustomerKey(this.key);
    }

    @Override
    public GetObjectRequest decorate(GetObjectRequest request) {
        return request.withSSECustomerKey(this.key);
    }

    @Override
    public GetObjectMetadataRequest decorate(GetObjectMetadataRequest request) {
        return request.withSSECustomerKey(this.key);
    }

    @Override
    public CopyObjectRequest decorate(CopyObjectRequest request) {
        return request.withSourceSSECustomerKey(this.key).withDestinationSSECustomerKey(this.key);
    }
}

