/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3;

import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.data.SearchableVersionedDataFinder;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.s3.S3DataSegmentPuller;
import org.apache.druid.storage.s3.S3Utils;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;

public class S3TimestampVersionedDataFinder
extends S3DataSegmentPuller
implements SearchableVersionedDataFinder<URI> {
    private static final int MAX_LISTING_KEYS = 1000;

    @Inject
    public S3TimestampVersionedDataFinder(ServerSideEncryptingAmazonS3 s3Client) {
        super(s3Client);
    }

    public URI getLatestVersion(URI uri, @Nullable Pattern pattern) {
        try {
            CloudObjectLocation coords = new CloudObjectLocation(S3Utils.checkURI(uri));
            long mostRecent = Long.MIN_VALUE;
            URI latest = null;
            Iterator<S3ObjectSummary> objectSummaryIterator = S3Utils.objectSummaryIterator(this.s3Client, Collections.singletonList(uri), 1000);
            while (objectSummaryIterator.hasNext()) {
                long latestModified;
                S3ObjectSummary objectSummary = objectSummaryIterator.next();
                CloudObjectLocation objectLocation = S3Utils.summaryToCloudObjectLocation(objectSummary);
                String keyString = StringUtils.maybeRemoveLeadingSlash((String)objectLocation.getPath().substring(coords.getPath().length()));
                if (pattern != null && !pattern.matcher(keyString).matches() || (latestModified = objectSummary.getLastModified().getTime()) < mostRecent) continue;
                mostRecent = latestModified;
                latest = objectLocation.toUri("s3");
            }
            return latest;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

