/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeDBInstanceAutomatedBackupsRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeDBInstanceAutomatedBackupsRequestMarshaller
implements Marshaller<Request<DescribeDBInstanceAutomatedBackupsRequest>, DescribeDBInstanceAutomatedBackupsRequest> {
    public Request<DescribeDBInstanceAutomatedBackupsRequest> marshall(DescribeDBInstanceAutomatedBackupsRequest describeDBInstanceAutomatedBackupsRequest) {
        if (describeDBInstanceAutomatedBackupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBInstanceAutomatedBackupsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeDBInstanceAutomatedBackups");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBInstanceAutomatedBackupsRequest.getDbiResourceId() != null) {
            request.addParameter("DbiResourceId", StringUtils.fromString((String)describeDBInstanceAutomatedBackupsRequest.getDbiResourceId()));
        }
        if (describeDBInstanceAutomatedBackupsRequest.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)describeDBInstanceAutomatedBackupsRequest.getDBInstanceIdentifier()));
        }
        if (!describeDBInstanceAutomatedBackupsRequest.getFilters().isEmpty() || !((SdkInternalList)describeDBInstanceAutomatedBackupsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeDBInstanceAutomatedBackupsRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDBInstanceAutomatedBackupsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBInstanceAutomatedBackupsRequest.getMaxRecords()));
        }
        if (describeDBInstanceAutomatedBackupsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBInstanceAutomatedBackupsRequest.getMarker()));
        }
        if (describeDBInstanceAutomatedBackupsRequest.getDBInstanceAutomatedBackupsArn() != null) {
            request.addParameter("DBInstanceAutomatedBackupsArn", StringUtils.fromString((String)describeDBInstanceAutomatedBackupsRequest.getDBInstanceAutomatedBackupsArn()));
        }
        return request;
    }
}

