/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkBaseException;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;

public class AWSClientUtil {
    private static final Set<String> RECOVERABLE_ERROR_CODES = ImmutableSet.of((Object)"503 SlowDown", (Object)"AuthFailure", (Object)"BandwidthLimitExceeded", (Object)"EC2ThrottledException", (Object)"IDPCommunicationError", (Object)"InternalError", (Object[])new String[]{"InvalidSignatureException", "PriorRequestNotComplete", "ProvisionedThroughputExceededException", "RequestExpired", "RequestInTheFuture", "RequestLimitExceeded", "RequestThrottled", "RequestThrottledException", "RequestTimeTooSkewed", "RequestTimeout", "RequestTimeoutException", "ServiceUnavailable", "SignatureDoesNotMatch", "SlowDown", "ThrottledException", "ThrottlingException", "TooManyRequestsException", "TransactionInProgressException", "Throttling"});

    public static boolean isClientExceptionRecoverable(AmazonClientException exception) {
        if (exception.getCause() instanceof IOException) {
            return true;
        }
        if (exception instanceof AmazonServiceException && "RequestTimeout".equals(((AmazonServiceException)exception).getErrorCode())) {
            return true;
        }
        if (RetryUtils.isRetryableServiceException((SdkBaseException)exception)) {
            return true;
        }
        if (RetryUtils.isThrottlingException((SdkBaseException)exception)) {
            return true;
        }
        if (RetryUtils.isClockSkewError((SdkBaseException)exception)) {
            return true;
        }
        if (exception instanceof MultiObjectDeleteException) {
            MultiObjectDeleteException multiObjectDeleteException = (MultiObjectDeleteException)exception;
            for (MultiObjectDeleteException.DeleteError error : multiObjectDeleteException.getErrors()) {
                if (!RECOVERABLE_ERROR_CODES.contains(error.getCode())) continue;
                return true;
            }
        }
        return false;
    }
}

