/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.parsers.CloseableIterator;

public class HandlingInputRowIterator
implements CloseableIterator<InputRow> {
    private final CloseableIterator<InputRow> delegate;
    private final List<InputRowHandler> inputRowHandlers;

    public HandlingInputRowIterator(CloseableIterator<InputRow> inputRowIterator, List<InputRowHandler> inputRowHandlers) {
        this.delegate = inputRowIterator;
        this.inputRowHandlers = inputRowHandlers;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    @Nullable
    public InputRow next() {
        InputRow inputRow = (InputRow)this.delegate.next();
        for (InputRowHandler inputRowHandler : this.inputRowHandlers) {
            if (!inputRowHandler.handle(inputRow)) continue;
            return null;
        }
        return inputRow;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @FunctionalInterface
    public static interface InputRowHandler {
        public boolean handle(InputRow var1);
    }
}

