/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.Rows;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.collect.Utils;
import org.apache.druid.segment.column.RowSignature;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ListBasedInputRow
implements InputRow {
    private final RowSignature signature;
    private final DateTime timestamp;
    private final List<String> dimensions;
    private final List<Object> data;

    public ListBasedInputRow(RowSignature signature, DateTime timestamp, List<String> dimensions, List<Object> data) {
        this.signature = signature;
        this.timestamp = timestamp;
        this.dimensions = dimensions;
        this.data = data;
    }

    public static InputRow parse(RowSignature signature, TimestampSpec timestampSpec, List<String> dimensions, List<Object> data) {
        DateTime timestamp = ListBasedInputRow.parseTimestamp(timestampSpec, data, signature);
        return new ListBasedInputRow(signature, timestamp, dimensions, data);
    }

    @Override
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @Override
    public long getTimestampFromEpoch() {
        return this.timestamp.getMillis();
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public List<String> getDimension(String dimension) {
        return Rows.objectToStrings(this.getRaw(dimension));
    }

    @Override
    @Nullable
    public Object getRaw(String columnName) {
        int i = this.signature.indexOf(columnName);
        if (i < 0 || i >= this.data.size()) {
            return null;
        }
        return this.data.get(i);
    }

    @Nullable
    public Object getRaw(int columnNumber) {
        if (columnNumber < this.data.size()) {
            return this.data.get(columnNumber);
        }
        return null;
    }

    @Override
    @Nullable
    public Number getMetric(String metric) {
        return Rows.objectToNumber(metric, this.getRaw(metric), true);
    }

    @Override
    public int compareTo(Row o) {
        return this.timestamp.compareTo((ReadableInstant)o.getTimestamp());
    }

    public Map<String, Object> asMap() {
        return Utils.zipMapPartial(this.signature.getColumnNames(), this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListBasedInputRow that = (ListBasedInputRow)o;
        return Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.signature, that.signature) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.dimensions, this.signature, this.data);
    }

    public String toString() {
        return "{timestamp=" + DateTimes.utc(this.getTimestampFromEpoch()) + ", event=" + this.asMap() + ", dimensions=" + this.dimensions + "}";
    }

    private static DateTime parseTimestamp(TimestampSpec timestampSpec, List<Object> theList, RowSignature signature) {
        int timeColumnIndex = signature.indexOf(timestampSpec.getTimestampColumn());
        Object timeValue = theList != null && timeColumnIndex >= 0 && timeColumnIndex < theList.size() ? theList.get(timeColumnIndex) : null;
        return MapInputRowParser.parseTimestampOrThrowParseException(timeValue, timestampSpec, () -> Utils.zipMapPartial(signature.getColumnNames(), theList));
    }
}

