/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFileAttribute;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.java.util.common.HumanReadableBytes;

public class SegmentsSplitHintSpec
implements SplitHintSpec {
    public static final String TYPE = "segments";
    private static final HumanReadableBytes DEFAULT_MAX_INPUT_SEGMENT_BYTES_PER_TASK = new HumanReadableBytes("1GiB");
    private static final int DEFAULT_MAX_NUM_SEGMENTS = 1000;
    private final HumanReadableBytes maxInputSegmentBytesPerTask;
    private final int maxNumSegments;

    @JsonCreator
    public SegmentsSplitHintSpec(@JsonProperty(value="maxInputSegmentBytesPerTask") @Nullable HumanReadableBytes maxInputSegmentBytesPerTask, @JsonProperty(value="maxNumSegments") @Nullable Integer maxNumSegments) {
        this.maxInputSegmentBytesPerTask = maxInputSegmentBytesPerTask == null ? DEFAULT_MAX_INPUT_SEGMENT_BYTES_PER_TASK : maxInputSegmentBytesPerTask;
        this.maxNumSegments = maxNumSegments == null ? 1000 : maxNumSegments;
    }

    @JsonProperty
    public HumanReadableBytes getMaxInputSegmentBytesPerTask() {
        return this.maxInputSegmentBytesPerTask;
    }

    @JsonProperty
    public int getMaxNumSegments() {
        return this.maxNumSegments;
    }

    @Override
    public <T> Iterator<List<T>> split(Iterator<T> inputIterator, Function<T, InputFileAttribute> inputAttributeExtractor) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentsSplitHintSpec that = (SegmentsSplitHintSpec)o;
        return this.maxNumSegments == that.maxNumSegments && Objects.equals(this.maxInputSegmentBytesPerTask, that.maxInputSegmentBytesPerTask);
    }

    public int hashCode() {
        return Objects.hash(this.maxInputSegmentBytesPerTask, this.maxNumSegments);
    }

    public String toString() {
        return "SegmentsSplitHintSpec{maxInputSegmentBytesPerTask=" + this.maxInputSegmentBytesPerTask + ", maxNumSegments=" + this.maxNumSegments + "}";
    }
}

