/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.extendedset.intset;

import org.apache.druid.extendedset.intset.IntSet;

public abstract class AbstractIntSet
implements IntSet {
    @Override
    public abstract IntSet clone();

    @Override
    public abstract IntSet.IntIterator iterator();

    @Override
    public abstract IntSet.IntIterator descendingIterator();

    @Override
    public abstract int size();

    @Override
    public abstract boolean isEmpty();

    public String toString() {
        IntSet.IntIterator itr = this.iterator();
        if (!itr.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            int e = itr.next();
            sb.append(e);
            if (!itr.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    @Override
    public int compareTo(IntSet o) {
        IntSet.IntIterator thisIterator = this.descendingIterator();
        IntSet.IntIterator otherIterator = o.descendingIterator();
        while (thisIterator.hasNext() && otherIterator.hasNext()) {
            int otherItem;
            int thisItem = thisIterator.next();
            if (thisItem < (otherItem = otherIterator.next())) {
                return -1;
            }
            if (thisItem <= otherItem) continue;
            return 1;
        }
        return thisIterator.hasNext() ? 1 : (otherIterator.hasNext() ? -1 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntSet)) {
            return false;
        }
        if (this.size() != ((IntSet)obj).size()) {
            return false;
        }
        IntSet.IntIterator itr1 = this.iterator();
        IntSet.IntIterator itr2 = ((IntSet)obj).iterator();
        while (itr1.hasNext()) {
            if (itr1.next() == itr2.next()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int h = 1;
        IntSet.IntIterator itr = this.iterator();
        if (!itr.hasNext()) {
            h = (h << 5) - h + itr.next();
        }
        return h;
    }
}

