/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.channel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.PartitionedOutputChannel;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.ResourceLimitExceededException;

public class ComposingWritableFrameChannel
implements WritableFrameChannel {
    @Nullable
    private final Integer partitionNumber;
    @Nullable
    private final List<Supplier<OutputChannel>> outputChannelSuppliers;
    @Nullable
    private final List<Supplier<PartitionedOutputChannel>> partitionedOutputChannelSuppliers;
    private final List<Supplier<WritableFrameChannel>> writableChannelSuppliers;
    private final Map<Integer, HashSet<Integer>> partitionToChannelMap;
    private int currentIndex;

    public ComposingWritableFrameChannel(@Nullable Integer partitionNumber, @Nullable List<Supplier<OutputChannel>> outputChannelSuppliers, @Nullable List<Supplier<PartitionedOutputChannel>> partitionedOutputChannelSuppliers, List<Supplier<WritableFrameChannel>> writableChannelSuppliers, Map<Integer, HashSet<Integer>> partitionToChannelMap) {
        if (outputChannelSuppliers != null && partitionedOutputChannelSuppliers != null) {
            throw new IAE("Atmost one of outputChannelSuppliers and partitionedOutputChannelSuppliers can be provided", new Object[0]);
        }
        this.partitionNumber = partitionNumber;
        this.outputChannelSuppliers = outputChannelSuppliers;
        this.partitionedOutputChannelSuppliers = partitionedOutputChannelSuppliers;
        this.writableChannelSuppliers = (List)Preconditions.checkNotNull(writableChannelSuppliers, (Object)"writableChannelSuppliers is null");
        this.partitionToChannelMap = (Map)Preconditions.checkNotNull(partitionToChannelMap, (Object)"partitionToChannelMap is null");
        this.currentIndex = 0;
    }

    @Override
    public void write(FrameWithPartition frameWithPartition) throws IOException {
        if (this.currentIndex >= this.writableChannelSuppliers.size()) {
            throw new ISE("No more channels available to write. Total available channels : " + this.writableChannelSuppliers.size(), new Object[0]);
        }
        if (this.partitionNumber != null && frameWithPartition.partition() != -1 && frameWithPartition.partition() != this.partitionNumber.intValue()) {
            throw DruidException.defensive("Invalid partition number[%d], expected[%d]", frameWithPartition.partition(), this.partitionNumber);
        }
        try {
            int writtenPartition = this.partitionNumber != null ? this.partitionNumber.intValue() : frameWithPartition.partition();
            this.writableChannelSuppliers.get(this.currentIndex).get().write(frameWithPartition);
            this.partitionToChannelMap.computeIfAbsent(writtenPartition, k -> Sets.newHashSetWithExpectedSize((int)1)).add(this.currentIndex);
        }
        catch (ResourceLimitExceededException rlee) {
            this.writableChannelSuppliers.get(this.currentIndex).get().close();
            this.convertChannelSuppliersToReadOnly(this.currentIndex);
            ++this.currentIndex;
            if (this.currentIndex >= this.writableChannelSuppliers.size()) {
                throw rlee;
            }
            this.write(frameWithPartition);
        }
    }

    private void convertChannelSuppliersToReadOnly(int index) {
        if (this.outputChannelSuppliers != null) {
            this.outputChannelSuppliers.get(index).get().convertToReadOnly();
        }
        if (this.partitionedOutputChannelSuppliers != null) {
            this.partitionedOutputChannelSuppliers.get(index).get().convertToReadOnly();
        }
    }

    @Override
    public void fail(@Nullable Throwable cause) throws IOException {
        for (Supplier<WritableFrameChannel> channel : this.writableChannelSuppliers) {
            channel.get().fail(cause);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.currentIndex < this.writableChannelSuppliers.size()) {
            this.writableChannelSuppliers.get(this.currentIndex).get().close();
            this.convertChannelSuppliersToReadOnly(this.currentIndex);
            this.currentIndex = this.writableChannelSuppliers.size();
        }
    }

    @Override
    public boolean isClosed() {
        return this.currentIndex == this.writableChannelSuppliers.size();
    }

    @Override
    public ListenableFuture<?> writabilityFuture() {
        return this.writableChannelSuppliers.get(this.currentIndex).get().writabilityFuture();
    }
}

