/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.java.util.common.concurrent.Execs;

public class AwaitAnyWidget {
    private final List<ReadableFrameChannel> channels;
    @GuardedBy(value="listeners")
    private final List<ChannelListener> listeners;

    public AwaitAnyWidget(List<ReadableFrameChannel> channels) {
        this.channels = channels;
        this.listeners = new ArrayList<ChannelListener>(channels.size());
        for (int i = 0; i < channels.size(); ++i) {
            this.listeners.add(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> awaitAny(IntSet awaitSet) {
        List<ChannelListener> list = this.listeners;
        synchronized (list) {
            SettableFuture retVal = SettableFuture.create();
            IntIterator awaitSetIterator = awaitSet.iterator();
            while (awaitSetIterator.hasNext()) {
                int channelNumber = awaitSetIterator.nextInt();
                ReadableFrameChannel channel = this.channels.get(channelNumber);
                if (channel.canRead() || channel.isFinished()) {
                    retVal.set(null);
                    return retVal;
                }
                ChannelListener priorListener = this.listeners.get(channelNumber);
                if (priorListener != null && priorListener.replaceFuture(retVal)) continue;
                ChannelListener newListener = new ChannelListener(retVal);
                channel.readabilityFuture().addListener((Runnable)newListener, (Executor)Execs.directExecutor());
                this.listeners.set(channelNumber, newListener);
            }
            return retVal;
        }
    }

    private static class ChannelListener
    implements Runnable {
        @GuardedBy(value="this")
        private SettableFuture<?> future;

        public ChannelListener(SettableFuture<?> future) {
            this.future = future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ChannelListener channelListener = this;
            synchronized (channelListener) {
                try {
                    this.future.set(null);
                }
                finally {
                    this.future = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean replaceFuture(SettableFuture<?> newFuture) {
            ChannelListener channelListener = this;
            synchronized (channelListener) {
                if (this.future == null) {
                    return false;
                }
                this.future = newFuture;
                return true;
            }
        }
    }
}

