/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.channel.ComposingReadableFrameChannel;
import org.apache.druid.frame.channel.ComposingWritableFrameChannel;
import org.apache.druid.frame.channel.PartitionedReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.PartitionedOutputChannel;

public class ComposingOutputChannelFactory
implements OutputChannelFactory {
    private final List<OutputChannelFactory> channelFactories;
    private final int frameSize;

    public ComposingOutputChannelFactory(List<OutputChannelFactory> channelFactories, int frameSize) {
        this.channelFactories = (List)Preconditions.checkNotNull(channelFactories, (Object)"channelFactories is null");
        this.frameSize = frameSize;
    }

    @Override
    public OutputChannel openChannel(int partitionNumber) {
        ImmutableList.Builder writableFrameChannelSuppliersBuilder = ImmutableList.builder();
        ImmutableList.Builder readableFrameChannelSuppliersBuilder = ImmutableList.builder();
        ImmutableList.Builder outputChannelSupplierBuilder = ImmutableList.builder();
        for (OutputChannelFactory channelFactory : this.channelFactories) {
            java.util.function.Supplier<OutputChannel> channel = () -> ((Supplier)Suppliers.memoize(() -> {
                try {
                    return channelFactory.openChannel(partitionNumber);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            })).get();
            outputChannelSupplierBuilder.add(channel);
            writableFrameChannelSuppliersBuilder.add(() -> ((OutputChannel)channel.get()).getWritableChannel());
            readableFrameChannelSuppliersBuilder.add(() -> ((OutputChannel)channel.get()).readOnly().getReadableChannelSupplier().get());
        }
        HashMap<Integer, HashSet<Integer>> partitionToChannelMap = new HashMap<Integer, HashSet<Integer>>();
        ComposingWritableFrameChannel writableFrameChannel = new ComposingWritableFrameChannel(partitionNumber, (List<java.util.function.Supplier<OutputChannel>>)outputChannelSupplierBuilder.build(), null, (List<java.util.function.Supplier<WritableFrameChannel>>)writableFrameChannelSuppliersBuilder.build(), partitionToChannelMap);
        java.util.function.Supplier<ReadableFrameChannel> readableFrameChannelSupplier = () -> ((Supplier)Suppliers.memoize(() -> new ComposingReadableFrameChannel(partitionNumber, (List<java.util.function.Supplier<ReadableFrameChannel>>)readableFrameChannelSuppliersBuilder.build(), (HashSet)partitionToChannelMap.get(partitionNumber)))).get();
        return OutputChannel.pair(writableFrameChannel, ArenaMemoryAllocator.createOnHeap(this.frameSize), readableFrameChannelSupplier, partitionNumber);
    }

    @Override
    public PartitionedOutputChannel openPartitionedChannel(String name, boolean deleteAfterRead) {
        ImmutableList.Builder writableFrameChannelsBuilder = ImmutableList.builder();
        ImmutableList.Builder readableFrameChannelSuppliersBuilder = ImmutableList.builder();
        ImmutableList.Builder partitionedOutputChannelSupplierBuilder = ImmutableList.builder();
        for (OutputChannelFactory channelFactory : this.channelFactories) {
            java.util.function.Supplier<PartitionedOutputChannel> channel = () -> ((Supplier)Suppliers.memoize(() -> {
                try {
                    return channelFactory.openPartitionedChannel(name, deleteAfterRead);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            })).get();
            partitionedOutputChannelSupplierBuilder.add(channel);
            writableFrameChannelsBuilder.add(() -> ((PartitionedOutputChannel)channel.get()).getWritableChannel());
            readableFrameChannelSuppliersBuilder.add(() -> ((PartitionedOutputChannel)channel.get()).readOnly().getReadableChannelSupplier().get());
        }
        HashMap<Integer, HashSet<Integer>> partitionToChannelMap = new HashMap<Integer, HashSet<Integer>>();
        ComposingWritableFrameChannel writableFrameChannel = new ComposingWritableFrameChannel(null, null, (List<java.util.function.Supplier<PartitionedOutputChannel>>)partitionedOutputChannelSupplierBuilder.build(), (List<java.util.function.Supplier<WritableFrameChannel>>)writableFrameChannelsBuilder.build(), partitionToChannelMap);
        ImmutableList readableFrameChannelSuppliers = readableFrameChannelSuppliersBuilder.build();
        PartitionedReadableFrameChannel partitionedReadableFrameChannel = new PartitionedReadableFrameChannel(){
            private final Set<Integer> openedChannels = Sets.newHashSetWithExpectedSize((int)1);
            final /* synthetic */ List val$readableFrameChannelSuppliers;
            final /* synthetic */ Map val$partitionToChannelMap;
            {
                this.val$readableFrameChannelSuppliers = list;
                this.val$partitionToChannelMap = map;
            }

            @Override
            public ReadableFrameChannel getReadableFrameChannel(int partitionNumber) {
                ImmutableList.Builder suppliers = ImmutableList.builder();
                int i = 0;
                while (i < this.val$readableFrameChannelSuppliers.size()) {
                    int finalI = i++;
                    suppliers.add(() -> ((Supplier)Suppliers.memoize(() -> {
                        this.openedChannels.add(finalI);
                        return ((PartitionedReadableFrameChannel)((java.util.function.Supplier)this.val$readableFrameChannelSuppliers.get(finalI)).get()).getReadableFrameChannel(partitionNumber);
                    })).get());
                }
                return new ComposingReadableFrameChannel(partitionNumber, (List<java.util.function.Supplier<ReadableFrameChannel>>)suppliers.build(), (HashSet)this.val$partitionToChannelMap.get(partitionNumber));
            }

            @Override
            public void close() throws IOException {
                for (Integer channelId : this.openedChannels) {
                    ((PartitionedReadableFrameChannel)((java.util.function.Supplier)this.val$readableFrameChannelSuppliers.get(channelId)).get()).close();
                }
            }
        };
        return PartitionedOutputChannel.pair(writableFrameChannel, ArenaMemoryAllocator.createOnHeap(this.frameSize), () -> partitionedReadableFrameChannel);
    }

    @Override
    public OutputChannel openNilChannel(int partitionNumber) {
        for (OutputChannelFactory outputChannelFactory : this.channelFactories) {
            outputChannelFactory.openNilChannel(partitionNumber);
        }
        return OutputChannel.nil(partitionNumber);
    }

    @Override
    public boolean isBuffered() {
        for (OutputChannelFactory channelFactory : this.channelFactories) {
            if (!channelFactory.isBuffered()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ComposingOutputChannelFactory{channelFactories=" + this.channelFactories + ", frameSize=" + this.frameSize + "}";
    }
}

