/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.error.DruidException;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.FilteredVectorInputBinding;
import org.apache.druid.query.filter.vector.VectorMatch;

public abstract class CaseSearchedFunctionVectorProcessor<T>
implements ExprVectorProcessor<T> {
    final ExpressionType outputType;
    final ExprVectorProcessor<?>[] conditionProcessors;
    final ExprVectorProcessor<T>[] thenProcessors;
    final FilteredVectorInputBinding conditionBindingFilterer;
    final FilteredVectorInputBinding thenBindingFilterer;

    public CaseSearchedFunctionVectorProcessor(ExpressionType outputType, ExprVectorProcessor<?>[] conditionProcessors, ExprVectorProcessor<T>[] thenProcessors) {
        this.outputType = outputType;
        this.conditionProcessors = conditionProcessors;
        this.thenProcessors = thenProcessors;
        this.conditionBindingFilterer = new FilteredVectorInputBinding(conditionProcessors[0].maxVectorSize());
        this.thenBindingFilterer = new FilteredVectorInputBinding(conditionProcessors[0].maxVectorSize());
    }

    protected abstract void processThenVector(ExprEvalVector<T> var1, int var2, int[] var3);

    protected abstract void processElseVector(ExprEvalVector<T> var1, int[] var2);

    protected abstract void processElseNull(int[] var1);

    protected abstract ExprEvalVector<T> makeResultVector();

    @Override
    public ExprEvalVector<T> evalVector(Expr.VectorInputBinding bindings) {
        int currentCondition;
        this.conditionBindingFilterer.setBindings(bindings);
        this.conditionBindingFilterer.getVectorMatch().copyFrom(VectorMatch.allTrue(bindings.getCurrentVectorSize()));
        this.thenBindingFilterer.setBindings(bindings);
        int totalMatches = 0;
        int currentMatches = 0;
        int currentMisses = 0;
        int[] conditionSelection = this.conditionBindingFilterer.getVectorMatch().getSelection();
        int[] thenSelection = this.thenBindingFilterer.getVectorMatch().getSelection();
        for (currentCondition = 0; totalMatches < bindings.getCurrentVectorSize() && currentCondition < this.conditionProcessors.length; ++currentCondition, totalMatches += currentMatches) {
            ExprEvalVector<?> conditionVector = this.conditionProcessors[currentCondition].evalVector(this.conditionBindingFilterer);
            for (int i = 0; i < this.conditionBindingFilterer.getCurrentVectorSize(); ++i) {
                int index = conditionSelection[i];
                if (conditionVector.elementAsBoolean(i)) {
                    thenSelection[currentMatches++] = index;
                    continue;
                }
                conditionSelection[currentMisses++] = index;
            }
            this.thenBindingFilterer.getVectorMatch().setSelectionSize(currentMatches);
            this.conditionBindingFilterer.getVectorMatch().setSelectionSize(currentMisses);
            ExprEvalVector<T> thenVector = this.thenProcessors[currentCondition].evalVector(this.thenBindingFilterer);
            this.processThenVector(thenVector, currentMatches, thenSelection);
            currentMisses = 0;
            currentMatches = 0;
        }
        if (totalMatches < bindings.getCurrentVectorSize()) {
            if (this.thenProcessors.length > this.conditionProcessors.length) {
                ExprEvalVector<T> elseVector = this.thenProcessors[currentCondition].evalVector(this.conditionBindingFilterer);
                this.processElseVector(elseVector, conditionSelection);
            } else {
                this.processElseNull(conditionSelection);
            }
            totalMatches += this.conditionBindingFilterer.getCurrentVectorSize();
        }
        if (totalMatches < bindings.getCurrentVectorSize()) {
            throw DruidException.defensive("output vector only populated with [%s] out of [%s] values", totalMatches, bindings.getCurrentVectorSize());
        }
        return this.makeResultVector();
    }

    @Override
    public ExpressionType getOutputType() {
        return this.outputType;
    }

    @Override
    public int maxVectorSize() {
        return this.conditionProcessors[0].maxVectorSize();
    }
}

