/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentMapFunction;
import org.apache.druid.segment.UnnestSegment;
import org.apache.druid.segment.VirtualColumn;

public class UnnestDataSource
implements DataSource {
    private final DataSource base;
    private final VirtualColumn virtualColumn;
    @Nullable
    private final DimFilter unnestFilter;

    private UnnestDataSource(DataSource dataSource, VirtualColumn virtualColumn, DimFilter unnestFilter) {
        this.base = dataSource;
        this.virtualColumn = virtualColumn;
        this.unnestFilter = unnestFilter;
    }

    @JsonCreator
    public static UnnestDataSource create(@JsonProperty(value="base") DataSource base, @JsonProperty(value="virtualColumn") VirtualColumn virtualColumn, @Nullable @JsonProperty(value="unnestFilter") DimFilter unnestFilter) {
        return new UnnestDataSource(base, virtualColumn, unnestFilter);
    }

    @JsonProperty(value="base")
    public DataSource getBase() {
        return this.base;
    }

    @JsonProperty(value="virtualColumn")
    public VirtualColumn getVirtualColumn() {
        return this.virtualColumn;
    }

    @JsonProperty(value="unnestFilter")
    public DimFilter getUnnestFilter() {
        return this.unnestFilter;
    }

    @Override
    public Set<String> getTableNames() {
        return this.base.getTableNames();
    }

    @Override
    public List<DataSource> getChildren() {
        return ImmutableList.of((Object)this.base);
    }

    @Override
    public DataSource withChildren(List<DataSource> children) {
        if (children.size() != 1) {
            throw new IAE("Expected [1] child, got [%d]", children.size());
        }
        return new UnnestDataSource(children.get(0), this.virtualColumn, this.unnestFilter);
    }

    @Override
    public boolean isCacheable(boolean isBroker) {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return this.base.isGlobal();
    }

    @Override
    public boolean isProcessable() {
        return this.base.isProcessable();
    }

    @Override
    public SegmentMapFunction createSegmentMapFunction(Query query) {
        return this.base.createSegmentMapFunction(query).thenMap(segment -> new UnnestSegment((Segment)segment, this.virtualColumn, this.unnestFilter));
    }

    @Override
    public byte[] getCacheKey() {
        return null;
    }

    public String toString() {
        return "UnnestDataSource{base=" + this.base + ", column='" + this.virtualColumn + "', unnestFilter='" + this.unnestFilter + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnnestDataSource that = (UnnestDataSource)o;
        return this.base.equals(that.base) && this.virtualColumn.equals(that.virtualColumn) && Objects.equals(this.unnestFilter, that.unnestFilter);
    }

    public int hashCode() {
        return Objects.hash(this.base, this.virtualColumn, this.unnestFilter);
    }
}

