/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.util.List;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;

public class StringAnyAggregator
implements Aggregator {
    private final BaseObjectColumnValueSelector valueSelector;
    private final int maxStringBytes;
    private boolean isFound;
    private String foundValue;
    private final boolean aggregateMultipleValues;

    public StringAnyAggregator(BaseObjectColumnValueSelector valueSelector, int maxStringBytes, boolean aggregateMultipleValues) {
        this.valueSelector = valueSelector;
        this.maxStringBytes = maxStringBytes;
        this.foundValue = null;
        this.isFound = false;
        this.aggregateMultipleValues = aggregateMultipleValues;
    }

    @Override
    public void aggregate() {
        if (!this.isFound) {
            Object object = this.valueSelector.getObject();
            this.foundValue = StringUtils.fastLooseChop(this.readValue(object), this.maxStringBytes);
            this.isFound = true;
        }
    }

    private String readValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            List objectList = (List)object;
            if (objectList.size() == 0) {
                return null;
            }
            if (objectList.size() == 1) {
                return DimensionHandlerUtils.convertObjectToString(objectList.get(0));
            }
            if (this.aggregateMultipleValues) {
                return DimensionHandlerUtils.convertObjectToString(objectList);
            }
            return DimensionHandlerUtils.convertObjectToString(objectList.get(0));
        }
        return DimensionHandlerUtils.convertObjectToString(object);
    }

    @Override
    public Object get() {
        return this.foundValue;
    }

    @Override
    public float getFloat() {
        throw new UnsupportedOperationException("StringAnyAggregator does not support getFloat()");
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException("StringAnyAggregator does not support getLong()");
    }

    @Override
    public double getDouble() {
        throw new UnsupportedOperationException("StringAnyAggregator does not support getDouble()");
    }

    @Override
    public void close() {
    }
}

