/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast.first;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.firstlast.FirstLastUtils;
import org.apache.druid.query.aggregation.firstlast.first.GenericFirstAggregateCombiner;
import org.apache.druid.query.aggregation.firstlast.first.SingleStringFirstDimensionVectorAggregator;
import org.apache.druid.query.aggregation.firstlast.first.StringFirstAggregator;
import org.apache.druid.query.aggregation.firstlast.first.StringFirstBufferAggregator;
import org.apache.druid.query.aggregation.firstlast.first.StringFirstVectorAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.ExpressionVectorSelectors;

@JsonTypeName(value="stringFirst")
public class StringFirstAggregatorFactory
extends AggregatorFactory {
    public static final ColumnType TYPE = ColumnType.ofComplex("serializablePairLongString");
    private static final Aggregator NIL_AGGREGATOR = new StringFirstAggregator((BaseLongColumnValueSelector)NilColumnValueSelector.instance(), (BaseObjectColumnValueSelector)NilColumnValueSelector.instance(), 0, false){

        @Override
        public void aggregate() {
        }
    };
    private static final BufferAggregator NIL_BUFFER_AGGREGATOR = new StringFirstBufferAggregator((BaseLongColumnValueSelector)NilColumnValueSelector.instance(), (BaseObjectColumnValueSelector)NilColumnValueSelector.instance(), 0, false){

        @Override
        public void aggregate(ByteBuffer buf, int position) {
        }
    };
    public static final VectorAggregator NIL_VECTOR_AGGREGATOR = new StringFirstVectorAggregator(null, null, 0){

        @Override
        public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        }

        @Override
        public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        }
    };
    public static final int DEFAULT_MAX_STRING_SIZE = 1024;
    public static final Comparator TIME_COMPARATOR = (o1, o2) -> Longs.compare((long)((Long)((SerializablePairLongString)o1).lhs), (long)((Long)((SerializablePairLongString)o2).lhs));
    public static final Comparator<SerializablePairLongString> VALUE_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(SerializablePair::getRhs, Comparator.nullsFirst(Comparator.naturalOrder())));
    private final String fieldName;
    private final String name;
    private final String timeColumn;
    protected final int maxStringBytes;

    @JsonCreator
    public StringFirstAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="timeColumn") @Nullable String timeColumn, @JsonProperty(value="maxStringBytes") Integer maxStringBytes) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        if (maxStringBytes != null && maxStringBytes < 0) {
            throw new IAE("maxStringBytes must be greater than 0", new Object[0]);
        }
        this.name = name;
        this.fieldName = fieldName;
        this.timeColumn = timeColumn == null ? "__time" : timeColumn;
        this.maxStringBytes = maxStringBytes == null ? 1024 : maxStringBytes;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_AGGREGATOR;
        }
        return new StringFirstAggregator(metricFactory.makeColumnValueSelector(this.timeColumn), valueSelector, this.maxStringBytes, FirstLastUtils.selectorNeedsFoldCheck(valueSelector, metricFactory.getColumnCapabilities(this.fieldName), SerializablePairLongString.class));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_BUFFER_AGGREGATOR;
        }
        return new StringFirstBufferAggregator(metricFactory.makeColumnValueSelector(this.timeColumn), valueSelector, this.maxStringBytes, FirstLastUtils.selectorNeedsFoldCheck(valueSelector, metricFactory.getColumnCapabilities(this.fieldName), SerializablePairLongString.class));
    }

    @Override
    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        SingleValueDimensionVectorSelector sSelector;
        VectorValueSelector timeSelector = selectorFactory.makeValueSelector(this.timeColumn);
        ColumnCapabilities capabilities = selectorFactory.getColumnCapabilities(this.fieldName);
        if (Types.isNumeric(capabilities)) {
            VectorValueSelector valueSelector = selectorFactory.makeValueSelector(this.fieldName);
            VectorObjectSelector objectSelector = ExpressionVectorSelectors.castValueSelectorToObject(selectorFactory.getReadableVectorInspector(), this.fieldName, valueSelector, capabilities.toColumnType(), ColumnType.STRING);
            return new StringFirstVectorAggregator(timeSelector, objectSelector, this.maxStringBytes);
        }
        if (capabilities != null && capabilities.is(ValueType.STRING) && capabilities.isDictionaryEncoded().isTrue() && !capabilities.hasMultipleValues().isTrue() && (sSelector = selectorFactory.makeSingleValueDimensionSelector(DefaultDimensionSpec.of(this.fieldName))).nameLookupPossibleInAdvance()) {
            return new SingleStringFirstDimensionVectorAggregator(timeSelector, sSelector, this.maxStringBytes);
        }
        VectorObjectSelector vSelector = selectorFactory.makeObjectSelector(this.fieldName);
        if (capabilities != null) {
            return new StringFirstVectorAggregator(timeSelector, vSelector, this.maxStringBytes);
        }
        return NIL_VECTOR_AGGREGATOR;
    }

    @Override
    public boolean canVectorize(ColumnInspector columnInspector) {
        return true;
    }

    @Override
    public Comparator getComparator() {
        return VALUE_COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return TIME_COMPARATOR.compare(lhs, rhs) <= 0 ? lhs : rhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new GenericFirstAggregateCombiner<SerializablePairLongString>(SerializablePairLongString.class);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new StringFirstAggregatorFactory(this.name, this.name, this.timeColumn, this.maxStringBytes);
    }

    @Override
    public Object deserialize(Object object) {
        Map map = (Map)object;
        return new SerializablePairLongString(((Number)map.get("lhs")).longValue(), (String)map.get("rhs"));
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? null : ((SerializablePairLongString)object).rhs;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public String getTimeColumn() {
        return this.timeColumn;
    }

    @JsonProperty
    public Integer getMaxStringBytes() {
        return this.maxStringBytes;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList(this.timeColumn, this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(43).appendString(this.fieldName).appendString(this.timeColumn).appendInt(this.maxStringBytes).build();
    }

    @Override
    public ColumnType getIntermediateType() {
        return TYPE;
    }

    @Override
    public ColumnType getResultType() {
        return ColumnType.STRING;
    }

    @Override
    public int getMaxIntermediateSize() {
        return 12 + this.maxStringBytes;
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new StringFirstAggregatorFactory(newName, this.getFieldName(), this.getTimeColumn(), this.getMaxStringBytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringFirstAggregatorFactory that = (StringFirstAggregatorFactory)o;
        return this.maxStringBytes == that.maxStringBytes && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.timeColumn, that.timeColumn) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.name, this.timeColumn, this.maxStringBytes);
    }

    public String toString() {
        return "StringFirstAggregatorFactory{fieldName='" + this.fieldName + "', name='" + this.name + "', timeColumn='" + this.timeColumn + "', maxStringBytes=" + this.maxStringBytes + "}";
    }
}

