/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeRangeSet;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Doubles;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.FalseDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NullableTypeStrategy;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.Utf8ValueSetIndexes;
import org.apache.druid.segment.index.semantic.ValueSetIndexes;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class TypedInFilter
extends AbstractOptimizableDimFilter
implements Filter {
    private final String column;
    private final ColumnType matchValueType;
    @Nullable
    private final List<?> unsortedValues;
    private final Supplier<List<?>> sortedMatchValues;
    @Nullable
    private final Supplier<List<ByteBuffer>> sortedUtf8MatchValueBytes;
    @Nullable
    private final FilterTuning filterTuning;
    private final Supplier<DruidPredicateFactory> predicateFactorySupplier;
    @JsonIgnore
    private final Supplier<byte[]> cacheKeySupplier;

    @JsonCreator
    public TypedInFilter(@JsonProperty(value="column") String column, @JsonProperty(value="matchValueType") ColumnType matchValueType, @JsonProperty(value="values") @Nullable List<?> values, @JsonProperty(value="sortedValues") @Nullable List<?> sortedValues, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        this.column = column;
        if (column == null) {
            throw InvalidInput.exception("Invalid IN filter, column cannot be null", new Object[0]);
        }
        this.filterTuning = filterTuning;
        this.matchValueType = matchValueType;
        if (matchValueType == null) {
            throw InvalidInput.exception("Invalid IN filter on column [%s], matchValueType cannot be null", column);
        }
        if (values == null && sortedValues == null || values != null && sortedValues != null) {
            throw InvalidInput.exception("Invalid IN filter on column [%s], exactly one of values or sortedValues must be non-null", column);
        }
        if (sortedValues != null) {
            this.unsortedValues = null;
            this.sortedMatchValues = () -> sortedValues;
            if (matchValueType.is(ValueType.STRING)) {
                ArrayList matchValueBytes = Lists.newArrayListWithCapacity((int)sortedValues.size());
                for (Object s : (List)this.sortedMatchValues.get()) {
                    matchValueBytes.add(StringUtils.toUtf8ByteBuffer(Evals.asString(s)));
                }
                this.sortedUtf8MatchValueBytes = () -> matchValueBytes;
            } else {
                this.sortedUtf8MatchValueBytes = null;
            }
        } else {
            if (TypedInFilter.checkSorted(values, matchValueType)) {
                this.unsortedValues = null;
                this.sortedMatchValues = () -> values;
            } else {
                this.unsortedValues = values;
                this.sortedMatchValues = Suppliers.memoize(() -> TypedInFilter.sortValues(this.unsortedValues, matchValueType));
            }
            this.sortedUtf8MatchValueBytes = null;
        }
        this.predicateFactorySupplier = Suppliers.memoize(() -> new PredicateFactory((List)this.sortedMatchValues.get(), matchValueType));
        this.cacheKeySupplier = Suppliers.memoize(this::computeCacheKey);
    }

    @JsonProperty
    public String getColumn() {
        return this.column;
    }

    @JsonProperty
    public List<?> getSortedValues() {
        return (List)this.sortedMatchValues.get();
    }

    @JsonProperty
    public ColumnType getMatchValueType() {
        return this.matchValueType;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    @Override
    public byte[] getCacheKey() {
        return (byte[])this.cacheKeySupplier.get();
    }

    @Override
    public DimFilter optimize(boolean mayIncludeUnknown) {
        List matchValues = (List)this.sortedMatchValues.get();
        if (matchValues.isEmpty()) {
            return FalseDimFilter.instance();
        }
        if (matchValues.size() == 1) {
            if (matchValues.get(0) == null) {
                return NullFilter.forColumn(this.column);
            }
            return new EqualityFilter(this.column, this.matchValueType, matchValues.iterator().next(), this.filterTuning);
        }
        return this;
    }

    @Override
    public Filter toFilter() {
        return this;
    }

    @Override
    @Nullable
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (!Objects.equals(this.getColumn(), dimension)) {
            return null;
        }
        TreeRangeSet retSet = TreeRangeSet.create();
        for (Object value : (List)this.sortedMatchValues.get()) {
            String valueEquivalent = Evals.asString(value);
            if (valueEquivalent == null) {
                retSet.add(Range.lessThan((Comparable)((Object)"")));
                continue;
            }
            retSet.add(Range.singleton((Comparable)((Object)valueEquivalent)));
        }
        return retSet;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.column);
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        ValueSetIndexes valueSetIndexes;
        Utf8ValueSetIndexes utf8ValueSetIndexes;
        if (!Filters.checkFilterTuningUseIndex(this.column, selector, this.filterTuning)) {
            return null;
        }
        ColumnIndexSupplier indexSupplier = selector.getIndexSupplier(this.column);
        if (indexSupplier == null) {
            DruidPredicateMatch match = ((DruidPredicateFactory)this.predicateFactorySupplier.get()).makeStringPredicate().apply(null);
            return Filters.makeMissingColumnNullIndex(match, selector);
        }
        if (this.sortedUtf8MatchValueBytes != null && (utf8ValueSetIndexes = indexSupplier.as(Utf8ValueSetIndexes.class)) != null) {
            return utf8ValueSetIndexes.forSortedValuesUtf8((List)this.sortedUtf8MatchValueBytes.get());
        }
        if (EqualityFilter.useSimpleEquality(selector.getColumnCapabilities(this.column), this.matchValueType) && (valueSetIndexes = indexSupplier.as(ValueSetIndexes.class)) != null) {
            return valueSetIndexes.forSortedValues((List)this.sortedMatchValues.get(), this.matchValueType);
        }
        return Filters.makePredicateIndex(this.column, selector, (DruidPredicateFactory)this.predicateFactorySupplier.get());
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.column, (DruidPredicateFactory)this.predicateFactorySupplier.get());
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return ColumnProcessors.makeVectorProcessor(this.column, VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher((DruidPredicateFactory)this.predicateFactorySupplier.get());
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        String rewriteDimensionTo = columnRewrites.get(this.column);
        if (rewriteDimensionTo == null) {
            throw new IAE("Received a non-applicable rewrite: %s, filter's dimension: %s", columnRewrites, this.column);
        }
        if (rewriteDimensionTo.equals(this.column)) {
            return this;
        }
        return new TypedInFilter(rewriteDimensionTo, this.matchValueType, null, (List)this.sortedMatchValues.get(), this.filterTuning);
    }

    public String toString() {
        DimFilter.DimFilterToStringBuilder builder = new DimFilter.DimFilterToStringBuilder();
        return builder.appendDimension(this.column, null).append(" IN (").append(Joiner.on((String)", ").join(Iterables.transform((Iterable)((Iterable)this.sortedMatchValues.get()), String::valueOf))).append(")").append(" (" + this.matchValueType + ")").appendFilterTuning(this.filterTuning).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedInFilter that = (TypedInFilter)o;
        return this.column.equals(that.column) && Objects.equals(this.matchValueType, that.matchValueType) && TypedInFilter.compareValues((List)this.sortedMatchValues.get(), (List)that.sortedMatchValues.get(), this.matchValueType) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.sortedMatchValues.get(), this.column, this.matchValueType, this.filterTuning);
    }

    private byte[] computeCacheKey() {
        Hasher hasher = Hashing.sha256().newHasher();
        for (Object v : (List)this.sortedMatchValues.get()) {
            if (v == null) {
                hasher.putInt(-1);
                continue;
            }
            String s = Evals.asString(v);
            hasher.putInt(s.length());
            hasher.putString((CharSequence)s, StandardCharsets.UTF_8);
        }
        return new CacheKeyBuilder(23).appendString(this.column).appendByte((byte)-1).appendString(this.matchValueType.asTypeString()).appendByte((byte)-1).appendByteArray(hasher.hash().asBytes()).build();
    }

    private InDimFilter convertToLegacy() {
        return new InDimFilter(this.column, InDimFilter.ValuesSet.copyOf(((List)this.sortedMatchValues.get()).stream().map(Evals::asString).iterator()), null, this.filterTuning);
    }

    private static boolean checkSorted(List<?> unsortedValues, ColumnType matchValueType) {
        NullableTypeStrategy<Object> comparator = matchValueType.getNullableStrategy();
        Object prev = null;
        for (Object o : unsortedValues) {
            Object coerced;
            if (o != null && (coerced = TypedInFilter.coerceValue(o, matchValueType)) != o) {
                return false;
            }
            if (prev != null && comparator.compare(prev, o) >= 0) {
                return false;
            }
            prev = o;
        }
        return true;
    }

    @Nullable
    private static <T> T coerceValue(@Nullable Object o, ColumnType matchValueType) {
        if (o == null) {
            return null;
        }
        switch ((ValueType)matchValueType.getType()) {
            case STRING: {
                return (T)DimensionHandlerUtils.convertObjectToString(o);
            }
            case LONG: {
                return (T)DimensionHandlerUtils.convertObjectToLong(o);
            }
            case FLOAT: {
                return (T)DimensionHandlerUtils.convertObjectToFloat(o);
            }
            case DOUBLE: {
                return (T)DimensionHandlerUtils.convertObjectToDouble(o);
            }
        }
        throw InvalidInput.exception("Unsupported matchValueType[%s]", matchValueType);
    }

    private static List<?> sortValues(List<?> unsortedValues, ColumnType matchValueType) {
        Object[] array = unsortedValues.toArray(new Object[0]);
        for (int i = 0; i < array.length; ++i) {
            Object coerced = TypedInFilter.coerceValue(array[i], matchValueType);
            array[i] = coerced;
        }
        NullableTypeStrategy<Object> comparator = matchValueType.getNullableStrategy();
        ObjectArrays.quickSort((Object[])array, comparator);
        ArrayList sortedList = Lists.newArrayListWithCapacity((int)array.length);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0 && comparator.compare(array[i - 1], array[i]) == 0) continue;
            sortedList.add(array[i]);
        }
        return sortedList;
    }

    private static boolean compareValues(List<?> o1, List<?> o2, ColumnType matchValueType) {
        int size2;
        NullableTypeStrategy<?> comparator = matchValueType.getNullableStrategy();
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        if (o2 == null) {
            return false;
        }
        int size1 = o1.size();
        if (size1 != (size2 = o2.size())) {
            return false;
        }
        for (int i = 0; i < size1; ++i) {
            int cmp = comparator.compare(o1.get(i), o2.get(i));
            if (cmp == 0) continue;
            return false;
        }
        return true;
    }

    private static DruidObjectPredicate<String> createStringPredicate(List<?> sortedValues, ColumnType matchValueType) {
        Preconditions.checkNotNull(sortedValues, (Object)"values");
        boolean containsNull = !sortedValues.isEmpty() && sortedValues.get(0) == null;
        NullableTypeStrategy comparator = matchValueType.getNullableStrategy();
        if (matchValueType.is(ValueType.STRING)) {
            return value -> {
                if (value == null) {
                    return containsNull ? DruidPredicateMatch.TRUE : DruidPredicateMatch.UNKNOWN;
                }
                int index = Collections.binarySearch(sortedValues, value, comparator);
                return DruidPredicateMatch.of(index >= 0);
            };
        }
        if (matchValueType.is(ValueType.LONG)) {
            LongOpenHashSet valueSet = new LongOpenHashSet(sortedValues.size());
            for (Object o : sortedValues) {
                Long l = DimensionHandlerUtils.convertObjectToLong(o);
                if (l == null) continue;
                valueSet.add(l.longValue());
            }
            return arg_0 -> TypedInFilter.lambda$createStringPredicate$6(containsNull, (LongSet)valueSet, arg_0);
        }
        if (matchValueType.isNumeric()) {
            DoubleOpenHashSet valueSet = new DoubleOpenHashSet(sortedValues.size());
            for (Object o : sortedValues) {
                Double d = DimensionHandlerUtils.convertObjectToDouble(o);
                if (d == null) continue;
                valueSet.add(d.doubleValue());
            }
            return arg_0 -> TypedInFilter.lambda$createStringPredicate$7(containsNull, (DoubleSet)valueSet, arg_0);
        }
        ExpressionType matchExpressionType = ExpressionType.fromColumnTypeStrict(matchValueType);
        HashSet stringSet = Sets.newHashSetWithExpectedSize((int)sortedValues.size());
        for (Object o : sortedValues) {
            stringSet.add(ExprEval.ofType(matchExpressionType, o).castTo(ExpressionType.STRING).asString());
        }
        return value -> {
            if (value == null) {
                return containsNull ? DruidPredicateMatch.TRUE : DruidPredicateMatch.UNKNOWN;
            }
            return DruidPredicateMatch.of(stringSet.contains(value));
        };
    }

    private static DruidLongPredicate createLongPredicate(final List<?> sortedValues, ColumnType matchValueType) {
        boolean matchNulls;
        boolean bl = matchNulls = !sortedValues.isEmpty() && sortedValues.get(0) == null;
        if (matchValueType.is(ValueType.LONG)) {
            final NullableTypeStrategy comparator = matchValueType.getNullableStrategy();
            return new DruidLongPredicate(){

                @Override
                public DruidPredicateMatch applyLong(long input) {
                    int index = Collections.binarySearch(sortedValues, input, comparator);
                    return DruidPredicateMatch.of(index >= 0);
                }

                @Override
                public DruidPredicateMatch applyNull() {
                    return matchNulls ? DruidPredicateMatch.TRUE : DruidPredicateMatch.UNKNOWN;
                }
            };
        }
        final LongOpenHashSet longs = new LongOpenHashSet();
        for (Object value : sortedValues) {
            Long longValue = DimensionHandlerUtils.convertObjectToLong(value);
            if (longValue == null) continue;
            longs.add(longValue.longValue());
        }
        return new DruidLongPredicate(){

            @Override
            public DruidPredicateMatch applyLong(long input) {
                return DruidPredicateMatch.of(longs.contains(input));
            }

            @Override
            public DruidPredicateMatch applyNull() {
                return matchNulls ? DruidPredicateMatch.TRUE : DruidPredicateMatch.UNKNOWN;
            }
        };
    }

    private static DruidFloatPredicate createFloatPredicate(final List<?> sortedValues, ColumnType matchValueType) {
        boolean matchNulls;
        boolean bl = matchNulls = !sortedValues.isEmpty() && sortedValues.get(0) == null;
        if (matchValueType.is(ValueType.FLOAT)) {
            final NullableTypeStrategy comparator = matchValueType.getNullableStrategy();
            return new DruidFloatPredicate(){

                @Override
                public DruidPredicateMatch applyFloat(float input) {
                    int index = Collections.binarySearch(sortedValues, Float.valueOf(input), comparator);
                    return DruidPredicateMatch.of(index >= 0);
                }

                @Override
                public DruidPredicateMatch applyNull() {
                    return matchNulls ? DruidPredicateMatch.TRUE : DruidPredicateMatch.UNKNOWN;
                }
            };
        }
        final FloatOpenHashSet floatSet = new FloatOpenHashSet();
        for (Object value : sortedValues) {
            Float floatValue = DimensionHandlerUtils.convertObjectToFloat(value);
            if (floatValue == null) continue;
            floatSet.add(floatValue.floatValue());
        }
        return new DruidFloatPredicate(){

            @Override
            public DruidPredicateMatch applyFloat(float input) {
                return DruidPredicateMatch.of(floatSet.contains(input));
            }

            @Override
            public DruidPredicateMatch applyNull() {
                return matchNulls ? DruidPredicateMatch.TRUE : DruidPredicateMatch.UNKNOWN;
            }
        };
    }

    private static DruidDoublePredicate createDoublePredicate(final List<?> sortedValues, ColumnType matchValueType) {
        boolean matchNulls;
        boolean bl = matchNulls = !sortedValues.isEmpty() && sortedValues.get(0) == null;
        if (matchValueType.is(ValueType.DOUBLE)) {
            final NullableTypeStrategy comparator = matchValueType.getNullableStrategy();
            return new DruidDoublePredicate(){

                @Override
                public DruidPredicateMatch applyDouble(double input) {
                    int index = Collections.binarySearch(sortedValues, input, comparator);
                    return DruidPredicateMatch.of(index >= 0);
                }

                @Override
                public DruidPredicateMatch applyNull() {
                    return matchNulls ? DruidPredicateMatch.TRUE : DruidPredicateMatch.UNKNOWN;
                }
            };
        }
        final DoubleOpenHashSet doubleSet = new DoubleOpenHashSet(sortedValues.size());
        for (Object value : sortedValues) {
            Double doubleValue = DimensionHandlerUtils.convertObjectToDouble(value);
            if (doubleValue == null) continue;
            doubleSet.add(doubleValue.doubleValue());
        }
        return new DruidDoublePredicate(){

            @Override
            public DruidPredicateMatch applyDouble(double input) {
                return DruidPredicateMatch.of(doubleSet.contains(input));
            }

            @Override
            public DruidPredicateMatch applyNull() {
                return matchNulls ? DruidPredicateMatch.TRUE : DruidPredicateMatch.UNKNOWN;
            }
        };
    }

    private static /* synthetic */ DruidPredicateMatch lambda$createStringPredicate$7(boolean containsNull, DoubleSet valueSet, String value) {
        if (value == null) {
            return containsNull ? DruidPredicateMatch.TRUE : DruidPredicateMatch.UNKNOWN;
        }
        Double d = Doubles.tryParse((String)value);
        if (d == null) {
            return DruidPredicateMatch.FALSE;
        }
        return DruidPredicateMatch.of(valueSet.contains((Object)d));
    }

    private static /* synthetic */ DruidPredicateMatch lambda$createStringPredicate$6(boolean containsNull, LongSet valueSet, String value) {
        if (value == null) {
            return containsNull ? DruidPredicateMatch.TRUE : DruidPredicateMatch.UNKNOWN;
        }
        Long castValue = GuavaUtils.tryParseLong(value);
        if (castValue == null) {
            return DruidPredicateMatch.FALSE;
        }
        return DruidPredicateMatch.of(valueSet.contains((Object)castValue));
    }

    public static class PredicateFactory
    implements DruidPredicateFactory {
        private final ColumnType matchValueType;
        private final List<?> sortedValues;
        private final Supplier<DruidObjectPredicate<String>> stringPredicateSupplier;
        private final Supplier<DruidLongPredicate> longPredicateSupplier;
        private final Supplier<DruidFloatPredicate> floatPredicateSupplier;
        private final Supplier<DruidDoublePredicate> doublePredicateSupplier;

        public PredicateFactory(List<?> sortedValues, ColumnType matchValueType) {
            this.sortedValues = sortedValues;
            this.matchValueType = matchValueType;
            this.stringPredicateSupplier = Suppliers.memoize(() -> TypedInFilter.createStringPredicate(sortedValues, matchValueType));
            this.longPredicateSupplier = Suppliers.memoize(() -> TypedInFilter.createLongPredicate(sortedValues, matchValueType));
            this.floatPredicateSupplier = Suppliers.memoize(() -> TypedInFilter.createFloatPredicate(sortedValues, matchValueType));
            this.doublePredicateSupplier = Suppliers.memoize(() -> TypedInFilter.createDoublePredicate(sortedValues, matchValueType));
        }

        @Override
        public DruidObjectPredicate<String> makeStringPredicate() {
            return (DruidObjectPredicate)this.stringPredicateSupplier.get();
        }

        @Override
        public DruidLongPredicate makeLongPredicate() {
            return (DruidLongPredicate)this.longPredicateSupplier.get();
        }

        @Override
        public DruidFloatPredicate makeFloatPredicate() {
            return (DruidFloatPredicate)this.floatPredicateSupplier.get();
        }

        @Override
        public DruidDoublePredicate makeDoublePredicate() {
            return (DruidDoublePredicate)this.doublePredicateSupplier.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateFactory that = (PredicateFactory)o;
            return Objects.equals(this.matchValueType, that.matchValueType) && Objects.equals(this.sortedValues, that.sortedValues);
        }

        public int hashCode() {
            return Objects.hash(this.matchValueType, this.sortedValues);
        }
    }
}

