/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.VByte;

public final class FrontCodedIntArrayIndexed
implements Indexed<int[]> {
    private final ByteBuffer buffer;
    private final int adjustedNumValues;
    private final int adjustIndex;
    private final int bucketSize;
    private final int numBuckets;
    private final int div;
    private final int rem;
    private final int offsetsPosition;
    private final int bucketsPosition;
    private final boolean hasNull;
    private final int lastBucketNumValues;
    private final int[] unwindPrefixLength;
    private final int[] unwindBufferPosition;

    public static Supplier<FrontCodedIntArrayIndexed> read(ByteBuffer buffer, ByteOrder ordering) {
        ByteBuffer orderedBuffer = buffer.asReadOnlyBuffer().order(ordering);
        byte version = orderedBuffer.get();
        Preconditions.checkArgument((version == 0 ? 1 : 0) != 0, (Object)("only V0 exists, encountered " + version));
        int bucketSize = Byte.toUnsignedInt(orderedBuffer.get());
        boolean hasNull = 1 == orderedBuffer.get();
        int numValues = VByte.readInt(orderedBuffer);
        int size = VByte.readInt(orderedBuffer);
        int offsetsPosition = orderedBuffer.position();
        buffer.position(offsetsPosition + size);
        return () -> new FrontCodedIntArrayIndexed(buffer, ordering, bucketSize, numValues, hasNull, offsetsPosition);
    }

    private FrontCodedIntArrayIndexed(ByteBuffer buffer, ByteOrder order, int bucketSize, int numValues, boolean hasNull, int offsetsPosition) {
        if (Integer.bitCount(bucketSize) != 1) {
            throw new ISE("bucketSize must be a power of two but was[%,d]", bucketSize);
        }
        this.buffer = buffer.asReadOnlyBuffer().order(order);
        this.bucketSize = bucketSize;
        this.hasNull = hasNull;
        this.numBuckets = (int)Math.ceil((double)numValues / (double)bucketSize);
        this.adjustIndex = hasNull ? 1 : 0;
        this.adjustedNumValues = numValues + this.adjustIndex;
        this.div = Integer.numberOfTrailingZeros(bucketSize);
        this.rem = bucketSize - 1;
        this.lastBucketNumValues = (numValues & this.rem) == 0 ? bucketSize : numValues & this.rem;
        this.offsetsPosition = offsetsPosition;
        this.bucketsPosition = offsetsPosition + (this.numBuckets - 1) * 4;
        this.unwindPrefixLength = new int[bucketSize];
        this.unwindBufferPosition = new int[bucketSize];
    }

    @Override
    public int size() {
        return this.adjustedNumValues;
    }

    @Override
    @Nullable
    public int[] get(int index) {
        if (this.hasNull && index == 0) {
            return null;
        }
        Indexed.checkIndex(index, this.adjustedNumValues);
        int adjustedIndex = index - this.adjustIndex;
        int bucket = adjustedIndex >> this.div;
        int bucketIndex = adjustedIndex & this.rem;
        int offset = this.getBucketOffset(bucket);
        this.buffer.position(offset);
        return this.getFromBucket(this.buffer, bucketIndex);
    }

    @Override
    public int indexOf(@Nullable int[] value) {
        int sharedPrefix;
        int comparison;
        int firstOffset;
        int firstLength;
        int offset;
        if (value == null) {
            return this.hasNull ? 0 : -1;
        }
        if (this.numBuckets == 0) {
            return this.hasNull ? -2 : -1;
        }
        int minBucketIndex = 0;
        int maxBucketIndex = this.numBuckets - 1;
        while (minBucketIndex < maxBucketIndex) {
            int currentBucket = minBucketIndex + maxBucketIndex >>> 1;
            int currBucketFirstValueIndex = currentBucket * this.bucketSize;
            offset = this.getBucketOffset(currentBucket);
            this.buffer.position(offset);
            firstLength = VByte.readInt(this.buffer);
            firstOffset = this.buffer.position();
            comparison = FrontCodedIntArrayIndexed.compareBucketFirstValue(this.buffer, firstLength, value);
            sharedPrefix = (this.buffer.position() - firstOffset) / 4;
            if (comparison == 0) {
                if (firstLength == value.length) {
                    return currBucketFirstValueIndex + this.adjustIndex;
                }
                comparison = Integer.compare(firstLength, value.length);
            }
            int nextOffset = this.getBucketOffset(currentBucket + 1);
            this.buffer.position(nextOffset);
            int nextLength = VByte.readInt(this.buffer);
            int comparisonNext = FrontCodedIntArrayIndexed.compareBucketFirstValue(this.buffer, nextLength, value);
            if (comparisonNext == 0) {
                if (nextLength == value.length) {
                    return currBucketFirstValueIndex + this.adjustIndex + this.bucketSize;
                }
                comparisonNext = Integer.compare(nextLength, value.length);
            }
            if (comparison < 0 && comparisonNext > 0) {
                this.buffer.position(firstOffset + firstLength * 4);
                return this.findValueInBucket(value, currBucketFirstValueIndex, this.bucketSize, sharedPrefix);
            }
            if (comparison < 0) {
                minBucketIndex = currentBucket + 1;
                continue;
            }
            maxBucketIndex = currentBucket - 1;
        }
        int bucketIndexBase = minBucketIndex * this.bucketSize;
        int numValuesInBucket = minBucketIndex == this.numBuckets - 1 ? this.lastBucketNumValues : this.bucketSize;
        offset = this.getBucketOffset(minBucketIndex);
        this.buffer.position(offset);
        firstLength = VByte.readInt(this.buffer);
        firstOffset = this.buffer.position();
        comparison = FrontCodedIntArrayIndexed.compareBucketFirstValue(this.buffer, firstLength, value);
        sharedPrefix = (this.buffer.position() - firstOffset) / 4;
        if (comparison == 0) {
            if (firstLength == value.length) {
                return bucketIndexBase + this.adjustIndex;
            }
            comparison = Integer.compare(firstLength, value.length);
        }
        if (comparison > 0) {
            return -(bucketIndexBase + this.adjustIndex) - 1;
        }
        this.buffer.position(firstOffset + firstLength * 4);
        return this.findValueInBucket(value, bucketIndexBase, numValuesInBucket, sharedPrefix);
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public Iterator<int[]> iterator() {
        if (this.adjustedNumValues == 0) {
            return Collections.emptyIterator();
        }
        if (this.hasNull && this.adjustedNumValues == 1) {
            return Collections.singletonList(null).iterator();
        }
        final ByteBuffer copy = this.buffer.asReadOnlyBuffer().order(this.buffer.order());
        copy.position(this.bucketsPosition);
        final int[][] firstBucket = FrontCodedIntArrayIndexed.readBucket(copy, this.numBuckets > 1 ? this.bucketSize : this.lastBucketNumValues);
        return new Iterator<int[]>(){
            private int currIndex = 0;
            private int currentBucketIndex = 0;
            private int[][] currentBucket = firstBucket;

            @Override
            public boolean hasNext() {
                return this.currIndex < FrontCodedIntArrayIndexed.this.adjustedNumValues;
            }

            @Override
            public int[] next() {
                int offset;
                if (FrontCodedIntArrayIndexed.this.hasNull && this.currIndex == 0) {
                    ++this.currIndex;
                    return null;
                }
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int adjustedCurrIndex = FrontCodedIntArrayIndexed.this.hasNull ? this.currIndex - 1 : this.currIndex;
                int bucketNum = adjustedCurrIndex >> FrontCodedIntArrayIndexed.this.div;
                if (bucketNum != this.currentBucketIndex) {
                    offset = copy.getInt(FrontCodedIntArrayIndexed.this.offsetsPosition + (bucketNum - 1) * 4);
                    copy.position(FrontCodedIntArrayIndexed.this.bucketsPosition + offset);
                    this.currentBucket = FrontCodedIntArrayIndexed.readBucket(copy, bucketNum < FrontCodedIntArrayIndexed.this.numBuckets - 1 ? FrontCodedIntArrayIndexed.this.bucketSize : FrontCodedIntArrayIndexed.this.lastBucketNumValues);
                    this.currentBucketIndex = bucketNum;
                }
                offset = adjustedCurrIndex & FrontCodedIntArrayIndexed.this.rem;
                ++this.currIndex;
                return this.currentBucket[offset];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("buffer", this.buffer);
        inspector.visit("hasNulls", this.hasNull);
        inspector.visit("bucketSize", this.bucketSize);
    }

    private int getBucketOffset(int bucket) {
        return this.bucketsPosition + (bucket > 0 ? this.buffer.getInt(this.offsetsPosition + (bucket - 1) * 4) : 0);
    }

    private static int compareBucketFirstValue(ByteBuffer bucketBuffer, int length, int[] value) {
        int startOffset = bucketBuffer.position();
        int commonLength = Math.min(length, value.length);
        int comparison = 0;
        for (int sharedPrefix = 0; sharedPrefix < commonLength; ++sharedPrefix) {
            comparison = Integer.compare(bucketBuffer.getInt(), value[sharedPrefix]);
            if (comparison == 0) continue;
            bucketBuffer.position(startOffset + sharedPrefix * 4);
            break;
        }
        return comparison;
    }

    private int findValueInBucket(int[] value, int currBucketFirstValueIndex, int bucketSize, int sharedPrefixLength) {
        int relativePosition = 0;
        int insertionPoint = 1;
        while (++relativePosition < bucketSize) {
            int prefixLength = VByte.readInt(this.buffer);
            if (prefixLength > sharedPrefixLength) {
                int skip = VByte.readInt(this.buffer);
                this.buffer.position(this.buffer.position() + skip * 4);
                ++insertionPoint;
                continue;
            }
            if (prefixLength < sharedPrefixLength) break;
            int fragmentLength = VByte.readInt(this.buffer);
            int common = Math.min(fragmentLength, value.length - prefixLength);
            int fragmentComparison = 0;
            boolean shortCircuit = false;
            for (int i = 0; i < common; ++i) {
                fragmentComparison = Integer.compare(this.buffer.getInt(this.buffer.position() + i * 4), value[prefixLength + i]);
                if (fragmentComparison == 0) continue;
                sharedPrefixLength = prefixLength + i;
                shortCircuit = true;
                break;
            }
            if (fragmentComparison == 0) {
                fragmentComparison = Integer.compare(prefixLength + fragmentLength, value.length);
            }
            if (fragmentComparison == 0) {
                return currBucketFirstValueIndex + this.adjustIndex + relativePosition;
            }
            if (fragmentComparison >= 0) break;
            if (!shortCircuit) {
                sharedPrefixLength = prefixLength + common;
            }
            this.buffer.position(this.buffer.position() + fragmentLength * 4);
            ++insertionPoint;
        }
        return -(currBucketFirstValueIndex + this.adjustIndex) + ~insertionPoint;
    }

    int[] getFromBucket(ByteBuffer buffer, int offset) {
        int i;
        int prefixLength;
        int length = VByte.readInt(buffer);
        if (offset == 0) {
            int[] firstValue = new int[length];
            for (int i2 = 0; i2 < length; ++i2) {
                firstValue[i2] = buffer.getInt();
            }
            return firstValue;
        }
        int pos = 0;
        this.unwindPrefixLength[pos] = 0;
        this.unwindBufferPosition[pos] = buffer.position();
        buffer.position(buffer.position() + length * 4);
        while (true) {
            prefixLength = VByte.readInt(buffer);
            if (++pos >= offset) break;
            int skipLength = VByte.readInt(buffer);
            this.unwindPrefixLength[pos] = prefixLength;
            this.unwindBufferPosition[pos] = buffer.position();
            buffer.position(buffer.position() + skipLength * 4);
        }
        int fragmentLength = VByte.readInt(buffer);
        if (prefixLength == 0) {
            int[] value = new int[fragmentLength];
            for (int i3 = 0; i3 < fragmentLength; ++i3) {
                value[i3] = buffer.getInt();
            }
            return value;
        }
        int valueLength = prefixLength + fragmentLength;
        int[] value = new int[valueLength];
        for (i = prefixLength; i < valueLength; ++i) {
            value[i] = buffer.getInt();
        }
        i = prefixLength;
        while (i > 0) {
            if (this.unwindPrefixLength[--pos] >= i) continue;
            buffer.position(this.unwindBufferPosition[pos]);
            int prevLength = this.unwindPrefixLength[pos];
            for (int fragmentOffset = 0; fragmentOffset < i - prevLength; ++fragmentOffset) {
                value[prevLength + fragmentOffset] = buffer.getInt();
            }
            i = this.unwindPrefixLength[pos];
        }
        return value;
    }

    private static int[][] readBucket(ByteBuffer bucket, int numValues) {
        int[][] bucketValues = new int[numValues][];
        int length = VByte.readInt(bucket);
        int[] prefix = new int[length];
        for (int i = 0; i < length; ++i) {
            prefix[i] = bucket.getInt();
        }
        bucketValues[0] = prefix;
        int pos = 1;
        while (pos < numValues) {
            int i;
            int prefixLength = VByte.readInt(bucket);
            int fragmentLength = VByte.readInt(bucket);
            int[] value = new int[prefixLength + fragmentLength];
            for (i = 0; i < prefixLength; ++i) {
                value[i] = prefix[i];
            }
            for (i = prefixLength; i < value.length; ++i) {
                value[i] = bucket.getInt();
            }
            prefix = value;
            bucketValues[pos++] = value;
        }
        return bucketValues;
    }
}

