/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.VirtualColumns;

public class IncrementalIndexSchema {
    private final long minTimestamp;
    private final TimestampSpec timestampSpec;
    private final Granularity queryGranularity;
    private final VirtualColumns virtualColumns;
    private final DimensionsSpec dimensionsSpec;
    private final AggregatorFactory[] metrics;
    private final boolean rollup;
    private final List<AggregateProjectionSpec> projections;

    public static Builder builder() {
        return new Builder();
    }

    public IncrementalIndexSchema(long minTimestamp, TimestampSpec timestampSpec, Granularity queryGranularity, VirtualColumns virtualColumns, DimensionsSpec dimensionsSpec, AggregatorFactory[] metrics, boolean rollup, List<AggregateProjectionSpec> projections) {
        this.minTimestamp = minTimestamp;
        this.timestampSpec = timestampSpec;
        this.queryGranularity = queryGranularity;
        this.virtualColumns = VirtualColumns.nullToEmpty(virtualColumns);
        this.dimensionsSpec = dimensionsSpec;
        this.metrics = metrics;
        this.rollup = rollup;
        this.projections = projections;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public TimestampSpec getTimestampSpec() {
        return this.timestampSpec;
    }

    public Granularity getQueryGranularity() {
        return this.queryGranularity;
    }

    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    public DimensionsSpec getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    public AggregatorFactory[] getMetrics() {
        return this.metrics;
    }

    public boolean isRollup() {
        return this.rollup;
    }

    public List<AggregateProjectionSpec> getProjections() {
        return this.projections;
    }

    public static class Builder {
        private long minTimestamp = 0L;
        private TimestampSpec timestampSpec;
        private Granularity queryGranularity = Granularities.NONE;
        private VirtualColumns virtualColumns = VirtualColumns.EMPTY;
        private DimensionsSpec dimensionsSpec = DimensionsSpec.EMPTY;
        private AggregatorFactory[] metrics = new AggregatorFactory[0];
        private boolean rollup = true;
        private List<AggregateProjectionSpec> projections = Collections.emptyList();

        public Builder withMinTimestamp(long minTimestamp) {
            this.minTimestamp = minTimestamp;
            return this;
        }

        public Builder withTimestampSpec(TimestampSpec timestampSpec) {
            this.timestampSpec = timestampSpec;
            return this;
        }

        public Builder withQueryGranularity(Granularity gran) {
            this.queryGranularity = gran;
            return this;
        }

        public Builder withVirtualColumns(VirtualColumns virtualColumns) {
            this.virtualColumns = virtualColumns;
            return this;
        }

        public Builder withDimensionsSpec(@Nullable DimensionsSpec dimensionsSpec) {
            this.dimensionsSpec = dimensionsSpec == null ? DimensionsSpec.EMPTY : dimensionsSpec;
            return this;
        }

        @Deprecated
        public Builder withDimensionsSpec(@Nullable InputRowParser parser) {
            this.dimensionsSpec = parser != null && parser.getParseSpec() != null && parser.getParseSpec().getDimensionsSpec() != null ? parser.getParseSpec().getDimensionsSpec() : DimensionsSpec.EMPTY;
            return this;
        }

        public Builder withMetrics(AggregatorFactory ... metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder withRollup(boolean rollup) {
            this.rollup = rollup;
            return this;
        }

        public Builder withProjections(@Nullable List<AggregateProjectionSpec> projections) {
            this.projections = projections == null ? Collections.emptyList() : projections;
            return this;
        }

        public IncrementalIndexSchema build() {
            return new IncrementalIndexSchema(this.minTimestamp, this.timestampSpec, this.queryGranularity, this.virtualColumns, this.dimensionsSpec, this.metrics, this.rollup, this.projections);
        }
    }
}

