/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.segment.join.Equality;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.filter.Equiconditions;
import org.apache.druid.segment.join.filter.JoinFilterColumnCorrelationAnalysis;
import org.apache.druid.segment.join.filter.JoinableClauses;
import org.apache.druid.segment.join.filter.rewrite.RhsRewriteCandidate;
import org.apache.druid.segment.join.filter.rewrite.RhsRewriteCandidates;

public class JoinFilterCorrelations {
    private final Map<String, List<JoinFilterColumnCorrelationAnalysis>> correlationsByFilteringColumn;
    private final Map<String, List<JoinFilterColumnCorrelationAnalysis>> correlationsByDirectFilteringColumn;

    private JoinFilterCorrelations(Map<String, List<JoinFilterColumnCorrelationAnalysis>> correlationsByFilteringColumn, Map<String, List<JoinFilterColumnCorrelationAnalysis>> correlationsByDirectFilteringColumn) {
        this.correlationsByFilteringColumn = correlationsByFilteringColumn;
        this.correlationsByDirectFilteringColumn = correlationsByDirectFilteringColumn;
    }

    public Map<String, List<JoinFilterColumnCorrelationAnalysis>> getCorrelationsByFilteringColumn() {
        return this.correlationsByFilteringColumn;
    }

    public Map<String, List<JoinFilterColumnCorrelationAnalysis>> getCorrelationsByDirectFilteringColumn() {
        return this.correlationsByDirectFilteringColumn;
    }

    public static JoinFilterCorrelations computeJoinFilterCorrelations(List<Filter> normalizedJoinTableClauses, Equiconditions equiconditions, JoinableClauses joinableClauses, boolean enableRewriteValueColumnFilters, long filterRewriteMaxSize) {
        List<JoinFilterColumnCorrelationAnalysis> dedupList;
        RhsRewriteCandidates rhsRewriteCandidates = RhsRewriteCandidates.getRhsRewriteCandidates(normalizedJoinTableClauses, equiconditions, joinableClauses);
        HashMap<String, Optional> correlationsByPrefix = new HashMap<String, Optional>();
        HashMap<String, Optional> directRewriteCorrelations = new HashMap<String, Optional>();
        for (RhsRewriteCandidate rhsRewriteCandidate : rhsRewriteCandidates.getRhsRewriteCandidates()) {
            if (rhsRewriteCandidate.isDirectRewrite()) {
                directRewriteCorrelations.computeIfAbsent(rhsRewriteCandidate.getRhsColumn(), c -> {
                    Optional<Map<String, JoinFilterColumnCorrelationAnalysis>> correlatedBaseTableColumns = JoinFilterCorrelations.findCorrelatedBaseTableColumns(joinableClauses, c, rhsRewriteCandidate, equiconditions);
                    if (!correlatedBaseTableColumns.isPresent()) {
                        return Optional.empty();
                    }
                    JoinFilterColumnCorrelationAnalysis baseColumnAnalysis = correlatedBaseTableColumns.get().get(c);
                    assert (baseColumnAnalysis != null);
                    return Optional.of(correlatedBaseTableColumns.get().get(c));
                });
                continue;
            }
            correlationsByPrefix.computeIfAbsent(rhsRewriteCandidate.getJoinableClause().getPrefix(), p -> JoinFilterCorrelations.findCorrelatedBaseTableColumns(joinableClauses, p, rhsRewriteCandidate, equiconditions));
        }
        LinkedHashMap<String, List<JoinFilterColumnCorrelationAnalysis>> correlationsByFilteringColumn = new LinkedHashMap<String, List<JoinFilterColumnCorrelationAnalysis>>();
        LinkedHashMap<String, List<JoinFilterColumnCorrelationAnalysis>> correlationsByDirectFilteringColumn = new LinkedHashMap<String, List<JoinFilterColumnCorrelationAnalysis>>();
        for (RhsRewriteCandidate rhsRewriteCandidate : rhsRewriteCandidates.getRhsRewriteCandidates()) {
            if (rhsRewriteCandidate.isDirectRewrite()) {
                List perColumnCorrelations = correlationsByDirectFilteringColumn.computeIfAbsent(rhsRewriteCandidate.getRhsColumn(), rhsCol -> new ArrayList());
                perColumnCorrelations.add((JoinFilterColumnCorrelationAnalysis)((Optional)directRewriteCorrelations.get(rhsRewriteCandidate.getRhsColumn())).get());
                continue;
            }
            Optional correlationsForPrefix = (Optional)correlationsByPrefix.get(rhsRewriteCandidate.getJoinableClause().getPrefix());
            if (correlationsForPrefix.isPresent()) {
                for (Map.Entry correlationForPrefix : ((Map)correlationsForPrefix.get()).entrySet()) {
                    List perColumnCorrelations = correlationsByFilteringColumn.computeIfAbsent(rhsRewriteCandidate.getRhsColumn(), rhsCol -> new ArrayList());
                    perColumnCorrelations.add((JoinFilterColumnCorrelationAnalysis)correlationForPrefix.getValue());
                    ((JoinFilterColumnCorrelationAnalysis)correlationForPrefix.getValue()).getCorrelatedValuesMap().computeIfAbsent(Pair.of(rhsRewriteCandidate.getRhsColumn(), rhsRewriteCandidate.getValueForRewrite()), rhsVal -> {
                        Optional<InDimFilter.ValuesSet> correlatedValues = JoinFilterCorrelations.getCorrelatedValuesForPushDown(rhsRewriteCandidate.getRhsColumn(), rhsRewriteCandidate.getValueForRewrite(), ((JoinFilterColumnCorrelationAnalysis)correlationForPrefix.getValue()).getJoinColumn(), rhsRewriteCandidate.getJoinableClause(), enableRewriteValueColumnFilters, filterRewriteMaxSize);
                        return correlatedValues;
                    });
                }
                continue;
            }
            correlationsByFilteringColumn.put(rhsRewriteCandidate.getRhsColumn(), null);
        }
        for (Map.Entry entry : correlationsByFilteringColumn.entrySet()) {
            if (entry.getValue() == null) continue;
            dedupList = JoinFilterCorrelations.eliminateCorrelationDuplicates((List)entry.getValue());
            correlationsByFilteringColumn.put((String)entry.getKey(), dedupList);
        }
        for (Map.Entry entry : correlationsByDirectFilteringColumn.entrySet()) {
            if (entry.getValue() == null) continue;
            dedupList = JoinFilterCorrelations.eliminateCorrelationDuplicates((List)entry.getValue());
            correlationsByDirectFilteringColumn.put((String)entry.getKey(), dedupList);
        }
        return new JoinFilterCorrelations(correlationsByFilteringColumn, correlationsByDirectFilteringColumn);
    }

    private static List<JoinFilterColumnCorrelationAnalysis> eliminateCorrelationDuplicates(List<JoinFilterColumnCorrelationAnalysis> originalList) {
        HashMap<HashSet<String>, JoinFilterColumnCorrelationAnalysis> uniquesMap = new HashMap<HashSet<String>, JoinFilterColumnCorrelationAnalysis>();
        for (JoinFilterColumnCorrelationAnalysis jca : originalList) {
            HashSet<String> mapKey = new HashSet<String>(jca.getBaseColumns());
            for (Expr expr : jca.getBaseExpressions()) {
                mapKey.add(expr.stringify());
            }
            uniquesMap.put(mapKey, jca);
        }
        return new ArrayList<JoinFilterColumnCorrelationAnalysis>(uniquesMap.values());
    }

    private static Optional<InDimFilter.ValuesSet> getCorrelatedValuesForPushDown(String filterColumn, String filterValue, String correlatedJoinColumn, JoinableClause clauseForFilteredTable, boolean enableRewriteValueColumnFilters, long filterRewriteMaxSize) {
        String filterColumnNoPrefix = filterColumn.substring(clauseForFilteredTable.getPrefix().length());
        String correlatedColumnNoPrefix = correlatedJoinColumn.substring(clauseForFilteredTable.getPrefix().length());
        return clauseForFilteredTable.getJoinable().getCorrelatedColumnValues(filterColumnNoPrefix, filterValue, correlatedColumnNoPrefix, filterRewriteMaxSize, enableRewriteValueColumnFilters);
    }

    private static Optional<Map<String, JoinFilterColumnCorrelationAnalysis>> findCorrelatedBaseTableColumns(JoinableClauses joinableClauses, String tablePrefix, RhsRewriteCandidate rhsRewriteCandidate, Equiconditions equiConditions) {
        JoinableClause clauseForTablePrefix = rhsRewriteCandidate.getJoinableClause();
        JoinConditionAnalysis jca = clauseForTablePrefix.getCondition();
        HashSet<Object> rhsColumns = new HashSet<Object>();
        if (rhsRewriteCandidate.isDirectRewrite()) {
            rhsColumns.add(rhsRewriteCandidate.getRhsColumn());
        } else {
            for (Equality eq : jca.getEquiConditions()) {
                rhsColumns.add(tablePrefix + eq.getRightColumn());
            }
        }
        LinkedHashMap<String, JoinFilterColumnCorrelationAnalysis> correlations = new LinkedHashMap<String, JoinFilterColumnCorrelationAnalysis>();
        for (String string : rhsColumns) {
            HashSet<String> correlatedBaseColumns = new HashSet<String>();
            HashSet<Expr> correlatedBaseExpressions = new HashSet<Expr>();
            JoinFilterCorrelations.getCorrelationForRHSColumn(joinableClauses, equiConditions, string, correlatedBaseColumns, correlatedBaseExpressions);
            if (correlatedBaseColumns.isEmpty() && correlatedBaseExpressions.isEmpty()) continue;
            correlations.put(string, new JoinFilterColumnCorrelationAnalysis(string, correlatedBaseColumns, correlatedBaseExpressions));
        }
        if (correlations.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(correlations);
    }

    private static void getCorrelationForRHSColumn(JoinableClauses joinableClauses, Equiconditions equiConditions, String rhsColumn, Set<String> correlatedBaseColumns, Set<Expr> correlatedBaseExpressions) {
        String findMappingFor = rhsColumn;
        Set<Expr> lhsExprs = equiConditions.getLhsExprs(findMappingFor);
        if (lhsExprs == null) {
            return;
        }
        for (Expr lhsExpr : lhsExprs) {
            String identifier = lhsExpr.getBindingIfIdentifier();
            if (identifier == null) {
                Expr.BindingAnalysis bindingAnalysis = lhsExpr.analyzeInputs();
                Set<String> requiredBindings = bindingAnalysis.getRequiredBindings();
                if (joinableClauses.areSomeColumnsFromJoin(requiredBindings)) break;
                correlatedBaseExpressions.add(lhsExpr);
                continue;
            }
            findMappingFor = identifier;
            if (joinableClauses.getColumnFromJoinIfExists(identifier) == null) {
                correlatedBaseColumns.add(findMappingFor);
                continue;
            }
            JoinFilterCorrelations.getCorrelationForRHSColumn(joinableClauses, equiConditions, findMappingFor, correlatedBaseColumns, correlatedBaseExpressions);
        }
    }
}

