/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.nested.ObjectStorageEncoding;

public class NestedCommonFormatColumnFormatSpec {
    private static final NestedCommonFormatColumnFormatSpec DEFAULT = NestedCommonFormatColumnFormatSpec.builder().setObjectFieldsDictionaryEncoding(StringEncodingStrategy.UTF8_STRATEGY).setObjectStorageEncoding(ObjectStorageEncoding.SMILE).build();
    @Nullable
    private final StringEncodingStrategy objectFieldsDictionaryEncoding;
    @Nullable
    private final ObjectStorageEncoding objectStorageEncoding;
    @Nullable
    private final CompressionStrategy objectStorageCompression;
    @Nullable
    private final StringEncodingStrategy stringDictionaryEncoding;
    @Nullable
    private final CompressionStrategy dictionaryEncodedColumnCompression;
    @Nullable
    private final CompressionFactory.LongEncodingStrategy longColumnEncoding;
    @Nullable
    private final CompressionStrategy longColumnCompression;
    @Nullable
    private final CompressionStrategy doubleColumnCompression;
    @Nullable
    private final BitmapSerdeFactory bitmapEncoding;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(NestedCommonFormatColumnFormatSpec spec) {
        return new Builder(spec);
    }

    public static NestedCommonFormatColumnFormatSpec getEffectiveFormatSpec(@Nullable NestedCommonFormatColumnFormatSpec columnFormatSpec, IndexSpec indexSpec) {
        Builder builder;
        Builder builder2 = builder = columnFormatSpec == null ? NestedCommonFormatColumnFormatSpec.builder() : NestedCommonFormatColumnFormatSpec.builder(columnFormatSpec);
        if (builder.bitmapEncoding != null && !builder.bitmapEncoding.equals(indexSpec.getBitmapSerdeFactory())) {
            throw new ISE("bitmapEncoding[%s] does not match indexSpec.bitmap[%s]", builder.bitmapEncoding, indexSpec.getBitmapSerdeFactory());
        }
        builder.setBitmapEncoding(indexSpec.getBitmapSerdeFactory());
        NestedCommonFormatColumnFormatSpec defaultSpec = indexSpec.getAutoColumnFormatSpec() != null ? indexSpec.getAutoColumnFormatSpec() : DEFAULT;
        if (builder.objectFieldsDictionaryEncoding == null) {
            if (defaultSpec.getObjectFieldsDictionaryEncoding() != null) {
                builder.setObjectFieldsDictionaryEncoding(defaultSpec.getObjectFieldsDictionaryEncoding());
            } else {
                builder.setObjectFieldsDictionaryEncoding(StringEncodingStrategy.DEFAULT);
            }
        }
        if (builder.objectStorageEncoding == null) {
            if (defaultSpec.getObjectStorageEncoding() != null) {
                builder.setObjectStorageEncoding(defaultSpec.getObjectStorageEncoding());
            } else {
                builder.setObjectStorageEncoding(ObjectStorageEncoding.SMILE);
            }
        }
        if (builder.objectStorageCompression == null) {
            if (defaultSpec.getObjectStorageCompression() != null) {
                builder.setObjectStorageCompression(defaultSpec.getObjectStorageCompression());
            } else if (indexSpec.getJsonCompression() != null) {
                builder.setObjectStorageCompression(indexSpec.getJsonCompression());
            } else {
                builder.setObjectStorageCompression(CompressionStrategy.LZ4);
            }
        }
        if (builder.stringDictionaryEncoding == null) {
            if (defaultSpec.getStringDictionaryEncoding() != null) {
                builder.setStringDictionaryEncoding(defaultSpec.getStringDictionaryEncoding());
            } else {
                builder.setStringDictionaryEncoding(indexSpec.getStringDictionaryEncoding());
            }
        }
        if (builder.dictionaryEncodedColumnCompression == null) {
            if (defaultSpec.getDictionaryEncodedColumnCompression() != null) {
                builder.setDictionaryEncodedColumnCompression(defaultSpec.getDictionaryEncodedColumnCompression());
            } else {
                builder.setDictionaryEncodedColumnCompression(indexSpec.getDimensionCompression());
            }
        }
        if (builder.longColumnEncoding == null) {
            if (defaultSpec.getLongColumnEncoding() != null) {
                builder.setLongColumnEncoding(defaultSpec.getLongColumnEncoding());
            } else {
                builder.setLongColumnEncoding(indexSpec.getLongEncoding());
            }
        }
        if (builder.longColumnCompression == null) {
            if (defaultSpec.getLongColumnCompression() != null) {
                builder.setLongColumnCompression(defaultSpec.getLongColumnCompression());
            } else {
                builder.setLongColumnCompression(indexSpec.getMetricCompression());
            }
        }
        if (builder.doubleColumnCompression == null) {
            if (defaultSpec.getDoubleColumnCompression() != null) {
                builder.setDoubleColumnCompression(defaultSpec.getDoubleColumnCompression());
            } else {
                builder.setDoubleColumnCompression(indexSpec.getMetricCompression());
            }
        }
        return builder.build();
    }

    @JsonCreator
    public NestedCommonFormatColumnFormatSpec(@JsonProperty(value="objectFieldsDictionaryEncoding") @Nullable StringEncodingStrategy objectFieldsDictionaryEncoding, @JsonProperty(value="objectStorageEncoding") @Nullable ObjectStorageEncoding objectStorageEncoding, @JsonProperty(value="objectStorageCompression") @Nullable CompressionStrategy objectStorageCompression, @JsonProperty(value="stringDictionaryEncoding") @Nullable StringEncodingStrategy stringDictionaryEncoding, @JsonProperty(value="dictionaryEncodedColumnCompression") @Nullable CompressionStrategy dictionaryEncodedColumnCompression, @JsonProperty(value="longColumnEncoding") @Nullable CompressionFactory.LongEncodingStrategy longColumnEncoding, @JsonProperty(value="longColumnCompression") @Nullable CompressionStrategy longColumnCompression, @JsonProperty(value="doubleColumnCompression") @Nullable CompressionStrategy doubleColumnCompression) {
        this(objectFieldsDictionaryEncoding, objectStorageEncoding, objectStorageCompression, stringDictionaryEncoding, dictionaryEncodedColumnCompression, longColumnEncoding, longColumnCompression, doubleColumnCompression, null);
    }

    protected NestedCommonFormatColumnFormatSpec(@Nullable StringEncodingStrategy objectFieldsDictionaryEncoding, @Nullable ObjectStorageEncoding objectStorageEncoding, @Nullable CompressionStrategy objectStorageCompression, @Nullable StringEncodingStrategy stringDictionaryEncoding, @Nullable CompressionStrategy dictionaryEncodedColumnCompression, @Nullable CompressionFactory.LongEncodingStrategy longColumnEncoding, @Nullable CompressionStrategy longColumnCompression, @Nullable CompressionStrategy doubleColumnCompression, @Nullable BitmapSerdeFactory bitmapEncoding) {
        this.objectFieldsDictionaryEncoding = objectFieldsDictionaryEncoding;
        this.objectStorageEncoding = objectStorageEncoding;
        this.objectStorageCompression = objectStorageCompression;
        this.stringDictionaryEncoding = stringDictionaryEncoding;
        this.dictionaryEncodedColumnCompression = dictionaryEncodedColumnCompression;
        this.longColumnEncoding = longColumnEncoding;
        this.longColumnCompression = longColumnCompression;
        this.doubleColumnCompression = doubleColumnCompression;
        this.bitmapEncoding = bitmapEncoding;
    }

    @Nullable
    @JsonProperty
    public StringEncodingStrategy getObjectFieldsDictionaryEncoding() {
        return this.objectFieldsDictionaryEncoding;
    }

    @Nullable
    @JsonProperty
    public ObjectStorageEncoding getObjectStorageEncoding() {
        return this.objectStorageEncoding;
    }

    @Nullable
    @JsonProperty
    public CompressionStrategy getObjectStorageCompression() {
        return this.objectStorageCompression;
    }

    @Nullable
    @JsonProperty
    public StringEncodingStrategy getStringDictionaryEncoding() {
        return this.stringDictionaryEncoding;
    }

    @Nullable
    @JsonProperty
    public CompressionStrategy getDictionaryEncodedColumnCompression() {
        return this.dictionaryEncodedColumnCompression;
    }

    @Nullable
    @JsonProperty
    public CompressionFactory.LongEncodingStrategy getLongColumnEncoding() {
        return this.longColumnEncoding;
    }

    @Nullable
    @JsonProperty
    public CompressionStrategy getLongColumnCompression() {
        return this.longColumnCompression;
    }

    @Nullable
    @JsonProperty
    public CompressionStrategy getDoubleColumnCompression() {
        return this.doubleColumnCompression;
    }

    @Nullable
    @JsonIgnore
    public BitmapSerdeFactory getBitmapEncoding() {
        return this.bitmapEncoding;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedCommonFormatColumnFormatSpec that = (NestedCommonFormatColumnFormatSpec)o;
        return Objects.equals(this.objectFieldsDictionaryEncoding, that.objectFieldsDictionaryEncoding) && this.objectStorageEncoding == that.objectStorageEncoding && this.objectStorageCompression == that.objectStorageCompression && Objects.equals(this.stringDictionaryEncoding, that.stringDictionaryEncoding) && this.dictionaryEncodedColumnCompression == that.dictionaryEncodedColumnCompression && this.longColumnEncoding == that.longColumnEncoding && this.longColumnCompression == that.longColumnCompression && this.doubleColumnCompression == that.doubleColumnCompression && Objects.equals(this.bitmapEncoding, that.bitmapEncoding);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.objectFieldsDictionaryEncoding, this.objectStorageEncoding, this.objectStorageCompression, this.stringDictionaryEncoding, this.dictionaryEncodedColumnCompression, this.longColumnEncoding, this.longColumnCompression, this.doubleColumnCompression, this.bitmapEncoding});
    }

    public String toString() {
        return "NestedCommonFormatColumnFormatSpec{objectFieldsDictionaryEncoding=" + this.objectFieldsDictionaryEncoding + ", objectStorageEncoding=" + this.objectStorageEncoding + ", objectStorageCompression=" + this.objectStorageCompression + ", stringDictionaryEncoding=" + this.stringDictionaryEncoding + ", dictionaryEncodedColumnCompression=" + this.dictionaryEncodedColumnCompression + ", longColumnEncoding=" + this.longColumnEncoding + ", longColumnCompression=" + this.longColumnCompression + ", doubleColumnCompression=" + this.doubleColumnCompression + ", bitmapEncoding=" + this.bitmapEncoding + "}";
    }

    public static class Builder {
        @Nullable
        private StringEncodingStrategy objectFieldsDictionaryEncoding;
        @Nullable
        private ObjectStorageEncoding objectStorageEncoding;
        @Nullable
        private CompressionStrategy objectStorageCompression;
        @Nullable
        private StringEncodingStrategy stringDictionaryEncoding;
        @Nullable
        private CompressionStrategy dictionaryEncodedColumnCompression;
        @Nullable
        private CompressionFactory.LongEncodingStrategy longColumnEncoding;
        @Nullable
        private CompressionStrategy longColumnCompression;
        @Nullable
        private CompressionStrategy doubleColumnCompression;
        @Nullable
        private BitmapSerdeFactory bitmapEncoding;

        public Builder() {
        }

        public Builder(NestedCommonFormatColumnFormatSpec spec) {
            this.objectFieldsDictionaryEncoding = spec.objectFieldsDictionaryEncoding;
            this.objectStorageEncoding = spec.objectStorageEncoding;
            this.objectStorageCompression = spec.objectStorageCompression;
            this.stringDictionaryEncoding = spec.stringDictionaryEncoding;
            this.dictionaryEncodedColumnCompression = spec.dictionaryEncodedColumnCompression;
            this.longColumnEncoding = spec.longColumnEncoding;
            this.longColumnCompression = spec.longColumnCompression;
            this.doubleColumnCompression = spec.doubleColumnCompression;
            this.bitmapEncoding = spec.bitmapEncoding;
        }

        public Builder setObjectFieldsDictionaryEncoding(@Nullable StringEncodingStrategy objectFieldsDictionaryEncoding) {
            this.objectFieldsDictionaryEncoding = objectFieldsDictionaryEncoding;
            return this;
        }

        public Builder setObjectStorageEncoding(@Nullable ObjectStorageEncoding objectStorageEncoding) {
            this.objectStorageEncoding = objectStorageEncoding;
            return this;
        }

        public Builder setObjectStorageCompression(@Nullable CompressionStrategy objectStorageCompression) {
            this.objectStorageCompression = objectStorageCompression;
            return this;
        }

        public Builder setStringDictionaryEncoding(@Nullable StringEncodingStrategy stringDictionaryEncoding) {
            this.stringDictionaryEncoding = stringDictionaryEncoding;
            return this;
        }

        public Builder setDictionaryEncodedColumnCompression(@Nullable CompressionStrategy dictionaryEncodedColumnCompression) {
            this.dictionaryEncodedColumnCompression = dictionaryEncodedColumnCompression;
            return this;
        }

        public Builder setLongColumnEncoding(@Nullable CompressionFactory.LongEncodingStrategy longColumnEncoding) {
            this.longColumnEncoding = longColumnEncoding;
            return this;
        }

        public Builder setLongColumnCompression(@Nullable CompressionStrategy longColumnCompression) {
            this.longColumnCompression = longColumnCompression;
            return this;
        }

        public Builder setDoubleColumnCompression(@Nullable CompressionStrategy doubleColumnCompression) {
            this.doubleColumnCompression = doubleColumnCompression;
            return this;
        }

        public Builder setBitmapEncoding(@Nullable BitmapSerdeFactory bitmapEncoding) {
            this.bitmapEncoding = bitmapEncoding;
            return this;
        }

        public NestedCommonFormatColumnFormatSpec build() {
            return new NestedCommonFormatColumnFormatSpec(this.objectFieldsDictionaryEncoding, this.objectStorageEncoding, this.objectStorageCompression, this.stringDictionaryEncoding, this.dictionaryEncodedColumnCompression, this.longColumnEncoding, this.longColumnCompression, this.doubleColumnCompression, this.bitmapEncoding);
        }
    }
}

