/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.projections;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.IsBooleanFilter;
import org.apache.druid.segment.filter.TrueFilter;

public final class ProjectionFilterMatch
extends TrueFilter {
    static final ProjectionFilterMatch INSTANCE = new ProjectionFilterMatch();

    private ProjectionFilterMatch() {
    }

    @Nullable
    public static Filter rewriteFilter(Filter projectionFilter, Filter queryFilter) {
        if (projectionFilter.equals(queryFilter)) {
            return INSTANCE;
        }
        if (queryFilter instanceof IsBooleanFilter && ((IsBooleanFilter)queryFilter).isTrue()) {
            IsBooleanFilter isTrueFilter = (IsBooleanFilter)queryFilter;
            Filter rewritten = ProjectionFilterMatch.rewriteFilter(projectionFilter, isTrueFilter.getBaseFilter());
            if (rewritten == null) {
                return null;
            }
            if (rewritten == INSTANCE) {
                return INSTANCE;
            }
            return new IsBooleanFilter(rewritten, true);
        }
        if (queryFilter instanceof AndFilter) {
            AndFilter andFilter = (AndFilter)queryFilter;
            if (projectionFilter instanceof AndFilter) {
                AndFilter projectionAndFilter = (AndFilter)projectionFilter;
                Filter rewritten = andFilter;
                for (Filter filter : projectionAndFilter.getFilters()) {
                    rewritten = ProjectionFilterMatch.rewriteFilter(filter, rewritten);
                    if (rewritten != null) {
                        if (rewritten != INSTANCE) continue;
                        return INSTANCE;
                    }
                    return null;
                }
                if (rewritten != null) {
                    return rewritten;
                }
                return null;
            }
            ArrayList newChildren = Lists.newArrayListWithExpectedSize((int)andFilter.getFilters().size());
            boolean childRewritten = false;
            for (Filter filter : andFilter.getFilters()) {
                Filter rewritten = ProjectionFilterMatch.rewriteFilter(projectionFilter, filter);
                if (rewritten == INSTANCE) {
                    childRewritten = true;
                    continue;
                }
                if (rewritten != null) {
                    newChildren.add(rewritten);
                    childRewritten = true;
                    continue;
                }
                newChildren.add(filter);
            }
            if (childRewritten) {
                if (newChildren.size() > 1) {
                    return new AndFilter(newChildren);
                }
                return (Filter)newChildren.get(0);
            }
            return null;
        }
        return null;
    }
}

