/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.base.Function;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ObjectStrategyComplexTypeStrategy;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexColumnPartSupplier;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.CompressedComplexColumnSerializer;
import org.apache.druid.segment.serde.CompressedComplexColumnSupplier;
import org.apache.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public abstract class ComplexMetricSerde {
    public abstract String getTypeName();

    public abstract ComplexMetricExtractor getExtractor();

    @Deprecated
    public abstract ObjectStrategy getObjectStrategy();

    public <T extends Comparable<T>> TypeStrategy<T> getTypeStrategy() {
        return new ObjectStrategyComplexTypeStrategy(this.getObjectStrategy(), ColumnType.ofComplex(this.getTypeName()));
    }

    @Nullable
    public Function<Object, Long> inputSizeFn() {
        return null;
    }

    public byte[] toBytes(@Nullable Object val) {
        if (val != null) {
            byte[] bytes = this.getObjectStrategy().toBytes(val);
            return bytes != null ? bytes : ByteArrays.EMPTY_ARRAY;
        }
        return ByteArrays.EMPTY_ARRAY;
    }

    public Object fromBytes(byte[] data, int start, int numBytes) {
        ByteBuffer bb = ByteBuffer.wrap(data);
        if (start > 0) {
            bb.position(start);
        }
        return this.getObjectStrategy().fromByteBuffer(bb, numBytes);
    }

    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
        this.deserializeColumn(buffer, builder);
    }

    @Deprecated
    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder builder) {
        int position = buffer.position();
        byte version = buffer.get();
        if (version == 127) {
            CompressedComplexColumnSupplier supplier = CompressedComplexColumnSupplier.read(buffer, builder, this.getTypeName(), this.getObjectStrategy());
            builder.setComplexColumnSupplier(supplier);
            builder.setNullValueIndexSupplier(supplier.getNullValues());
            builder.setHasNulls(!supplier.getNullValues().isEmpty());
        } else {
            buffer.position(position);
            builder.setComplexColumnSupplier(new ComplexColumnPartSupplier(this.getTypeName(), GenericIndexed.read(buffer, this.getObjectStrategy(), builder.getFileMapper())));
        }
    }

    @Nullable
    @Deprecated
    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column) {
        return null;
    }

    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column, IndexSpec indexSpec) {
        GenericColumnSerializer serializer = this.getSerializer(segmentWriteOutMedium, column);
        if (serializer != null) {
            return serializer;
        }
        CompressionStrategy strategy = indexSpec.getComplexMetricCompression();
        if (strategy == null || CompressionStrategy.NONE == strategy || CompressionStrategy.UNCOMPRESSED == strategy) {
            return LargeColumnSupportedComplexColumnSerializer.create(segmentWriteOutMedium, column, this.getObjectStrategy());
        }
        return CompressedComplexColumnSerializer.create(segmentWriteOutMedium, column, indexSpec, this.getObjectStrategy());
    }
}

